/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ProgramNameStatistics {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ProgramNameStatistics <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, ProgramData> programs = new HashMap<String, ProgramData>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(30, 4).stream().map(record -> Smf30Record.from((SmfRecord)record)).filter(r30 -> r30.completionSection() != null && !r30.completionSection().smf30flh()).filter(r30 -> r30.header().smf30wid().equals("JES2")).forEach(r30 -> {
                String programName = r30.identificationSection().smf30pgm();
                programs.computeIfAbsent(programName, x -> new ProgramData(programName)).add((Smf30Record)r30);
            });
        }
        ProgramNameStatistics.writeReport(programs);
    }

    private static void writeReport(Map<String, ProgramData> programs) {
        System.out.format("%n%-8s %11s %11s %11s %11s %14s %11s %11s %11s %11s %11s%n", "Name", "Count", "CPU(s)", "zIIP(s)", "Connect(s)", "Excp", "Avg CPU", "Avg zIIP", "Avg Connect", "Avg Excp", "CPU/IO");
        programs.values().stream().sorted(Comparator.comparingDouble(ProgramData::getCpTime).reversed()).limit(100L).forEachOrdered(program -> System.out.format("%-8s %11d %11.0f %11.0f %11.0f %14d %11.2f %11.2f %11.2f %11d %11f%n", program.getName(), program.getCount(), program.getCpTime(), program.getZiipTime(), program.getConnect(), program.getExcps(), program.getAvgCpTime(), program.getAvgZiipTime(), program.getAvgConnect(), program.getAvgExcps(), program.getCpuPerIo()));
    }

    private static class ProgramData {
        private String name;
        private int count = 0;
        private double cpTime = 0.0;
        private double ziipTime = 0.0;
        private double connect = 0.0;
        private long excps = 0L;

        public ProgramData(String programName) {
            this.name = programName;
        }

        public void add(Smf30Record record) {
            if (record.processorAccountingSection() != null) {
                ++this.count;
                this.cpTime += record.processorAccountingSection().smf30cptSeconds() + record.processorAccountingSection().smf30cpsSeconds();
                this.ziipTime += record.processorAccountingSection().smf30TimeOnZiipSeconds();
            }
            if (record.ioActivitySection() != null) {
                this.excps += record.ioActivitySection().smf30tex();
                this.connect += record.ioActivitySection().smf30aicSeconds();
            }
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public double getCpTime() {
            return this.cpTime;
        }

        public double getZiipTime() {
            return this.ziipTime;
        }

        public double getConnect() {
            return this.connect;
        }

        public long getExcps() {
            return this.excps;
        }

        public Double getAvgCpTime() {
            return this.count == 0 ? null : Double.valueOf(this.cpTime / (double)this.count);
        }

        public Double getAvgZiipTime() {
            return this.count == 0 ? null : Double.valueOf(this.ziipTime / (double)this.count);
        }

        public Double getAvgConnect() {
            return this.count == 0 ? null : Double.valueOf(this.connect / (double)this.count);
        }

        public Long getAvgExcps() {
            return this.count == 0 ? null : Long.valueOf(this.excps / (long)this.count);
        }

        public Double getCpuPerIo() {
            return this.excps == 0L ? null : Double.valueOf((this.cpTime + this.ziipTime) / (double)this.excps);
        }
    }
}

