/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.zedc;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.blackhillsoftware.smf.smf30.ZEdcUsageStatisticsSection;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;

public class ZedcBeforeAfter {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ZedcBeforeAfter <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap zedc = new HashMap();
        HashMap noZedc = new HashMap();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(30, 4);){
            reader.stream().map(record -> Smf30Record.from((SmfRecord)record)).filter(r30 -> r30.completionSection() != null).filter(r30 -> r30.header().smf30wid().equals("JES2")).forEach(r30 -> {
                if (r30.zEdcUsageStatisticsSections().isEmpty()) {
                    noZedc.computeIfAbsent(r30.identificationSection().smf30jbn(), jobName -> new JobInfo((String)jobName)).add((Smf30Record)r30);
                } else {
                    zedc.computeIfAbsent(r30.identificationSection().smf30jbn(), jobName -> new JobInfo((String)jobName)).add((Smf30Record)r30);
                }
            });
        }
        String headingFormat = "%-8s %6s %9s %9s %9s %9s %9s %10s %8s %10s %8s%n";
        String detailFormat = "%-8s %,6d %9.1f %9.2f %9.2f %9.2f %9d%n";
        String zedcDetailFormat = "%-8s %,6d %9.1f %9.2f %9.2f %9.2f %9d %,10d %6.1f:1 %,10d %6.1f:1%n";
        String deltaFormat = "%-8s %6s %+8.0f%% %+8.0f%% %+8.0f%% %+8.0f%% %+8.0f%%%n%n";
        System.out.format(headingFormat, "Jobname", "Count", "Ave Elap", "Avg CP", "Avg zIIP", "Avg Conn", "Avg EXCP", "Avg Rd MB", "Ratio", "Avg Wr MB", "Ratio");
        HashSet reportJobs = new HashSet(zedc.keySet());
        reportJobs.retainAll(noZedc.keySet());
        reportJobs.stream().sorted().forEachOrdered(jobname -> {
            JobInfo dataset = (JobInfo)noZedc.get(jobname);
            System.out.format(detailFormat, dataset.getJobname(), dataset.count, dataset.avgElapsed(), dataset.avgCp(), dataset.avgZiip(), dataset.avgConnect(), dataset.avgExcp());
            JobInfo zedcDataset = (JobInfo)zedc.get(jobname);
            System.out.format(zedcDetailFormat, " ZEDC:", zedcDataset.count, zedcDataset.avgElapsed(), zedcDataset.avgCp(), zedcDataset.avgZiip(), zedcDataset.avgConnect(), zedcDataset.avgExcp(), zedcDataset.avgUncompRead() / 0x100000L, Float.valueOf(zedcDataset.readCompRatio()), zedcDataset.avgUncompWrite() / 0x100000L, Float.valueOf(zedcDataset.writeCompRatio()));
            System.out.format(deltaFormat, "", "", ZedcBeforeAfter.changePct(dataset.avgElapsed(), zedcDataset.avgElapsed()), ZedcBeforeAfter.changePct(dataset.avgCp(), zedcDataset.avgCp()), ZedcBeforeAfter.changePct(dataset.avgZiip(), zedcDataset.avgZiip()), ZedcBeforeAfter.changePct(dataset.avgConnect(), zedcDataset.avgConnect()), ZedcBeforeAfter.changePct(dataset.avgExcp(), zedcDataset.avgExcp()));
        });
        System.out.println("Done");
    }

    static double changePct(double before, double after) {
        if (before == 0.0) {
            return 0.0;
        }
        return (after - before) / before * 100.0;
    }

    static class JobInfo {
        String jobname;
        int count = 0;
        long compRead = 0L;
        long uncompRead = 0L;
        long compWrite = 0L;
        long uncompWrite = 0L;
        double elapsedSeconds = 0.0;
        double connectSeconds = 0.0;
        double cpSeconds = 0.0;
        double ziipSeconds = 0.0;
        long excp = 0L;

        JobInfo(String datasetName) {
            this.jobname = datasetName;
        }

        void add(Smf30Record r30) {
            ++this.count;
            LocalDateTime start = r30.identificationSection().smf30std().atTime(r30.identificationSection().smf30sit());
            this.elapsedSeconds += (double)Duration.between(start, r30.smfDateTime()).toMillis() / 1000.0;
            if (r30.ioActivitySection() != null) {
                this.excp += r30.ioActivitySection().smf30tex();
                this.connectSeconds += r30.ioActivitySection().smf30tcnSeconds();
            }
            if (r30.processorAccountingSection() != null) {
                this.cpSeconds += r30.processorAccountingSection().smf30cptSeconds() + r30.processorAccountingSection().smf30cpsSeconds();
                this.ziipSeconds += r30.processorAccountingSection().smf30TimeOnZiipSeconds();
            }
            if (!r30.zEdcUsageStatisticsSections().isEmpty()) {
                ZEdcUsageStatisticsSection zedc = (ZEdcUsageStatisticsSection)r30.zEdcUsageStatisticsSections().get(0);
                this.compRead += zedc.smf30UsInfComprIn();
                this.uncompRead += zedc.smf30UsInfDecomprOut();
                this.uncompWrite += zedc.smf30UsDefUncomprIn();
                this.compWrite += zedc.smf30UsDefComprOut();
            }
        }

        String getJobname() {
            return this.jobname;
        }

        double avgElapsed() {
            return this.elapsedSeconds / (double)this.count;
        }

        double avgConnect() {
            return this.connectSeconds / (double)this.count;
        }

        double avgCp() {
            return this.cpSeconds / (double)this.count;
        }

        double avgZiip() {
            return this.ziipSeconds / (double)this.count;
        }

        long avgExcp() {
            return this.excp / (long)this.count;
        }

        long avgUncompRead() {
            return this.uncompRead / (long)this.count;
        }

        long avgUncompWrite() {
            return this.uncompWrite / (long)this.count;
        }

        float readCompRatio() {
            if (this.compRead == 0L) {
                return 0.0f;
            }
            return (float)this.uncompRead / (float)this.compRead;
        }

        float writeCompRatio() {
            if (this.compWrite == 0L) {
                return 0.0f;
            }
            return (float)this.uncompWrite / (float)this.compWrite;
        }
    }
}

