/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.zedc;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf14.CompressedFormatDatasetSection;
import com.blackhillsoftware.smf.smf14.StepInformationSection;
import com.blackhillsoftware.smf.smf15.Smf15Record;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Comparator;

public class ZedcWriteRatio {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ZedcWriteRatio <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        String headingFormat = "%-6s %-24s %-8s %-8s %-44s %8s %13s %13s %6s%n";
        String detailFormat = "%-6s %-24s %-8s %-8s %-44s %8d %,13d %,13d %6.1f%n";
        System.out.format(headingFormat, "System", "Time", "Job", "Program", "Dataset", "BLKSIZE", "C-Size MB", "C-Written MB", "Ratio");
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(15);){
            reader.stream().map(record -> Smf15Record.from((SmfRecord)record)).filter(r15 -> r15.compressedFormatDatasetSections().size() > 0).map(r15 -> new CompressionInfo((Smf15Record)r15)).filter(compressionInfo -> compressionInfo.writeRatio() > 1.0f).sorted(Comparator.comparingDouble(CompressionInfo::writeRatio).reversed()).limit(1000L).forEachOrdered(dataset -> System.out.format(detailFormat, dataset.system, dataset.dateTime, dataset.jobname, dataset.program, dataset.dataset, dataset.blksize, dataset.sizeMB, dataset.writtenMB, Float.valueOf(dataset.writeRatio())));
            System.out.println("Done");
        }
    }

    static class CompressionInfo {
        LocalDateTime dateTime;
        String system;
        String jobname;
        String program;
        String dataset;
        int blksize;
        long sizeMB;
        long writtenMB;

        CompressionInfo(Smf15Record r15) {
            this.dateTime = r15.smfDateTime();
            this.system = r15.system();
            this.jobname = r15.smf14jbn();
            this.program = ((StepInformationSection)r15.stepInformationSections().get(0)).smf14pgn();
            this.dataset = r15.smfjfcb1().jfcbdsnm();
            this.blksize = r15.smfjfcb1().jfcblksi();
            this.sizeMB = ((CompressedFormatDatasetSection)r15.compressedFormatDatasetSections().get(0)).smf14cds() / 0x100000L;
            this.writtenMB = ((CompressedFormatDatasetSection)r15.compressedFormatDatasetSections().get(0)).smf14cdl() / 0x100000L;
        }

        float writeRatio() {
            if (this.sizeMB == 0L) {
                return 0.0f;
            }
            return (float)this.writtenMB / (float)this.sizeMB;
        }
    }
}

