/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.sample;

import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.realtime.MissedDataEvent;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDateTime;

public class RtiHttpJson {
    public static void main(String[] args) throws IOException, InterruptedException, URISyntaxException {
        if (args.length < 2) {
            System.out.println("Usage: RtiHttpJson <resource-name> <url>");
            return;
        }
        String inMemoryResource = args[0];
        String url = args[1];
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(new URI(url)).header("Content-Type", "application/json");
        Gson gson = new EasySmfGsonBuilder().avoidScientificNotation(true).includeZeroValues(false).includeUnsetFlags(false).includeEmptyStrings(false).createGson();
        try (SmfConnection connection = SmfConnection.forResourceName((String)inMemoryResource).disconnectOnStop().onMissedData(RtiHttpJson::handleMissedData).connect();
             SmfRecordReader reader = SmfRecordReader.fromByteArrays((Iterable<byte[]>)connection).include(30, 5);){
            for (SmfRecord record : reader) {
                Smf30Record r30 = Smf30Record.from(record);
                if (r30.completionSection() == null) continue;
                CompositeEntry compositeEntry = new CompositeEntry();
                compositeEntry.add("time", (Object)r30.smfDateTime());
                compositeEntry.add("system", (Object)r30.system());
                compositeEntry.add("jobname", (Object)r30.identificationSection().smf30jbn());
                compositeEntry.add("jobid", (Object)r30.identificationSection().smf30jnm());
                LocalDateTime start = r30.identificationSection().smf30std().atTime(r30.identificationSection().smf30sit());
                compositeEntry.add("start_time", (Object)start);
                compositeEntry.add("elapsed", (Object)Duration.between(start, r30.smfDateTime()));
                compositeEntry.add("cpTime", (Object)(r30.processorAccountingSection().smf30cptSeconds() + r30.processorAccountingSection().smf30cpsSeconds() + r30.processorAccountingSection().smf30icuStepInitSeconds() + r30.processorAccountingSection().smf30icuStepTermSeconds() + r30.processorAccountingSection().smf30isbStepInitSeconds() + r30.processorAccountingSection().smf30isbStepTermSeconds() + r30.processorAccountingSection().smf30iipSeconds() + r30.processorAccountingSection().smf30rctSeconds() + r30.processorAccountingSection().smf30hptSeconds()));
                compositeEntry.add("ziipTime", (Object)r30.processorAccountingSection().smf30TimeOnZiipSeconds());
                compositeEntry.add("identification", (Object)r30.identificationSection());
                compositeEntry.add("completion", (Object)r30.completionSection());
                compositeEntry.add("processor_accounting", (Object)r30.processorAccountingSection());
                compositeEntry.add("performance", (Object)r30.performanceSection());
                compositeEntry.add("io_activity", (Object)r30.ioActivitySection());
                compositeEntry.add("storage", (Object)r30.storageSection());
                String json = gson.toJson((Object)compositeEntry);
                HttpRequest request = requestBuilder.POST(HttpRequest.BodyPublishers.ofString(json)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) continue;
                System.out.println(response.statusCode() + " " + response.body());
            }
        }
    }

    static void handleMissedData(MissedDataEvent e) {
        System.out.println("Missed Data!");
        e.throwException(false);
    }
}

