/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public final class AggregateGroup
extends DcollectRecord {
    public static final int DAGTENQ = 128;
    public static final int DAGFRET = 64;
    public static final int DAGFNCPY = 32;
    private List<IDsnMem> m_dagdsnms = null;

    AggregateGroup(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.AG)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    AggregateGroup(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.AG)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static AggregateGroup from(VRecord record) {
        return new AggregateGroup(record);
    }

    private int dagnmlen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public String dagname() {
        if (this.data.length >= 26 + this.dagnmlen()) {
            return Util.ConvertEbcdic(this.data, 26, this.dagnmlen());
        }
        return null;
    }

    public String daguser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dagdate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dagdateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime dagtime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String dagtimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String dagdesc() {
        return Util.ConvertEbcdic(this.data, 84, 120);
    }

    public int dagflags() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public boolean dagtenq() {
        return Util.ConvertFlag(this.data, this.dagflags(), 128);
    }

    public boolean dagfret() {
        return Util.ConvertFlag(this.data, this.dagflags(), 64);
    }

    public boolean dagfncpy() {
        return Util.ConvertFlag(this.data, this.dagflags(), 32);
    }

    public int dagretpd() {
        return Util.ConvertSignedBinary4(this.data, 208);
    }

    public int dagexpyr() {
        return Util.ConvertSignedBinary2(this.data, 208);
    }

    public int dagexpdy() {
        return Util.ConvertSignedBinary2(this.data, 210);
    }

    public String dagdest() {
        return Util.ConvertEbcdic(this.data, 212, 30);
    }

    public String dagprefx() {
        return Util.ConvertEbcdic(this.data, 242, 33);
    }

    public IDsnMem dagidsnm() {
        return IDsnMem.create(this.data, 276, 52);
    }

    public String dagindsn() {
        return Util.ConvertEbcdic(this.data, 276, 44);
    }

    public String daginmem() {
        return Util.ConvertEbcdic(this.data, 320, 8);
    }

    public List<IDsnMem> dagdsnms() {
        if (this.m_dagdsnms != null) {
            return this.m_dagdsnms;
        }
        ArrayList<IDsnMem> result = new ArrayList<IDsnMem>(5);
        for (int i = 0; i < 5; ++i) {
            result.add(IDsnMem.create(this.data, Field.dagdsnms.offset() + i * Field.dagdsnms.length(), Field.dagdsnms.length()));
        }
        this.m_dagdsnms = result;
        return this.m_dagdsnms;
    }

    private int dagmclen() {
        return Util.ConvertUnsignedBinary2(this.data, 588);
    }

    public String dagmcnam() {
        if (this.data.length >= 590 + this.dagmclen()) {
            return Util.ConvertEbcdic(this.data, 590, this.dagmclen());
        }
        return null;
    }

    public int dagncopy() {
        return Util.ConvertSignedBinary4(this.data, 620);
    }

    public static final class IDsnMem
    extends Data {
        private IDsnMem(byte[] Data2, int offset, int length) {
            super(Data2, offset, length);
        }

        public String dagdsn() {
            return Util.ConvertEbcdic(this.data, 0, 44);
        }

        public String dagmem() {
            return Util.ConvertEbcdic(this.data, 44, 8);
        }

        public static IDsnMem create(byte[] Data2, int offset, int length) {
            return new IDsnMem(Data2, offset, length);
        }

        static enum Field {
            dagdsn(0, 44),
            dagmem(44, 8);

            private final int offset;
            private final int length;

            private Field(int offset, int length) {
                this.offset = offset;
                this.length = length;
            }

            private Field() {
                this.offset = 0;
                this.length = 0;
            }

            int offset() {
                return this.offset;
            }

            int length() {
                return this.length;
            }
        }
    }

    static enum Field {
        dagnmlen(24, 2),
        dagname(26, 0),
        daguser(56, 8),
        dagdate(64, 10),
        dagtime(76, 8),
        dagdesc(84, 120),
        dagflags(204, 1),
        dagretpd(208, 4),
        dagexpyr(208, 2),
        dagexpdy(210, 2),
        dagdest(212, 30),
        dagprefx(242, 33),
        dagidsnm(276, 52),
        dagindsn(276, 44),
        daginmem(320, 8),
        dagdsnms(328, 52),
        dagmclen(588, 2),
        dagmcnam(590, 0),
        dagncopy(620, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

