/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BaseConfiguration
extends DcollectRecord {
    public static final int DBC32NAM = 128;
    private List<String> m_dbcfsysn = null;
    private List<SystemFeatures> m_dbcsfeat = null;
    private List<NameType> m_dbcsysnt = null;
    private List<SystemInformation> m_dbcsysdt = null;

    BaseConfiguration(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.BC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    BaseConfiguration(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.BC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static BaseConfiguration from(VRecord record) {
        return new BaseConfiguration(record);
    }

    public String dbcuser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dbcdate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dbcdateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime dbctime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String dbctimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String dbcdesc() {
        return Util.ConvertEbcdic(this.data, 84, 120);
    }

    public int dbcflags() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public int dbcflgdc() {
        return Util.ConvertUnsignedBinary1(this.data, 205);
    }

    public boolean dbc32nam() {
        return Util.ConvertFlag(this.data, this.dbcflgdc(), 128);
    }

    private int dbcmclen() {
        return Util.ConvertUnsignedBinary2(this.data, 208);
    }

    public String dbcdefmc() {
        if (this.data.length >= 210 + this.dbcmclen()) {
            return Util.ConvertEbcdic(this.data, 210, this.dbcmclen());
        }
        return null;
    }

    public int dbctrksz() {
        return Util.ConvertSignedBinary4(this.data, 240);
    }

    public int dbccylcp() {
        return Util.ConvertSignedBinary4(this.data, 244);
    }

    public String dbcdunit() {
        return Util.ConvertEbcdic(this.data, 248, 8);
    }

    public Token dbcsrst() {
        if (this.data.length >= 264) {
            return new Token(this.data, 256, 8);
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(256) + " Data length: " + Integer.toString(8));
    }

    public ScdsStatus dbcstat() {
        int value = Util.ConvertUnsignedBinary1(this.data, 264);
        return ScdsStatus.from(value);
    }

    public int dbcstatRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 264);
    }

    public List<String> dbcfsysn() {
        if (this.m_dbcfsysn != null) {
            return this.m_dbcfsysn;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            String name = Util.ConvertEbcdic(this.data, Field.dbcfsysn.offset + i * Field.dbcfsysn.length, Field.dbcfsysn.length);
            result.add(name);
        }
        this.m_dbcfsysn = result;
        return this.m_dbcfsysn;
    }

    public String dbcscdsn() {
        return Util.ConvertEbcdic(this.data, 332, 44);
    }

    public List<SystemFeatures> dbcsfeat() {
        if (this.m_dbcsfeat != null) {
            return this.m_dbcsfeat;
        }
        ArrayList<SystemFeatures> result = new ArrayList<SystemFeatures>();
        for (int i = 0; i < 8; ++i) {
            result.add(SystemFeatures.create(this.data, Field.dbcsfeat.offset + i * Field.dbcsfeat.length, Field.dbcsfeat.length));
        }
        this.m_dbcsfeat = result;
        return this.m_dbcsfeat;
    }

    public List<NameType> dbcsysnt() {
        if (this.m_dbcsysnt != null) {
            return this.m_dbcsysnt;
        }
        ArrayList<NameType> result = new ArrayList<NameType>();
        for (int i = 0; i < 8; ++i) {
            int value = Util.ConvertUnsignedBinary1(this.data, Field.dbcsysnt.offset + i * Field.dbcsysnt.length);
            result.add(NameType.from(value));
        }
        this.m_dbcsysnt = result;
        return this.m_dbcsysnt;
    }

    public List<Integer> dbcsysntRawValue() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < 8; ++i) {
            int value = Util.ConvertUnsignedBinary1(this.data, Field.dbcsysnt.offset + i * Field.dbcsysnt.length);
            result.add(value);
        }
        return result;
    }

    public List<SystemInformation> dbcsysdt() {
        if (this.m_dbcsysdt != null) {
            return this.m_dbcsysdt;
        }
        ArrayList<SystemInformation> result = new ArrayList<SystemInformation>();
        for (int i = 0; i < 32; ++i) {
            result.add(SystemInformation.create(this.data, Field.dbcsysdt.offset + i * Field.dbcsysdt.length, Field.dbcsysdt.length));
        }
        this.m_dbcsysdt = result;
        return this.m_dbcsysdt;
    }

    public int dbcsepnl() {
        return Util.ConvertUnsignedBinary2(this.data, 928);
    }

    public String dbcsepnm() {
        if (this.data.length >= 930 + this.dbcsepnl()) {
            return Util.ConvertEbcdic(this.data, 930, this.dbcsepnl());
        }
        return null;
    }

    public static enum ScdsStatus {
        NULL(0),
        VALID(1),
        INVALID(2),
        UNKNOWN(3),
        NOT_DEFINED(-16);

        private static Map<Integer, ScdsStatus> valueMap;
        private final transient int basedatasetstatus;

        private ScdsStatus(int basedatasetstatus) {
            this.basedatasetstatus = basedatasetstatus;
        }

        public static ScdsStatus from(int value) {
            ScdsStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int basedatasetstatus() {
            return this.basedatasetstatus;
        }

        static {
            valueMap = new HashMap<Integer, ScdsStatus>();
            for (ScdsStatus x : ScdsStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.basedatasetstatus, x);
            }
        }
    }

    static enum Field {
        dbcuser(56, 8),
        dbcdate(64, 10),
        dbctime(76, 8),
        dbcdesc(84, 120),
        dbcflags(204, 1),
        dbcflgdc(205, 1),
        dbcmclen(208, 2),
        dbcmcnam(210, 0),
        dbctrksz(240, 4),
        dbccylcp(244, 4),
        dbcdunit(248, 8),
        dbcsrst(256, 8),
        dbcstat(264, 1),
        dbcfsysn(268, 8),
        dbcscdsn(332, 44),
        dbcsfeat(376, 2),
        dbcsysnt(392, 1),
        dbcsysdt(400, 16),
        dbcsepnl(928, 2),
        dbcsepnm(930, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }

    public static final class SystemFeatures
    extends Data {
        public static final int DBCASMS = 32768;
        public static final int DBCPDSE = 16384;
        public static final int DBCCDMP = 8192;
        public static final int DBCSESC = 4096;

        private SystemFeatures(byte[] Data2, int offset, int length) {
            super(Data2, offset, length);
        }

        private int rawValue() {
            return Util.ConvertUnsignedBinary2(this.data, 0);
        }

        public boolean dbcasms() {
            return Util.ConvertFlag(this.data, this.rawValue(), 32768);
        }

        public boolean dbcpdse() {
            return Util.ConvertFlag(this.data, this.rawValue(), 16384);
        }

        public boolean dbccdmp() {
            return Util.ConvertFlag(this.data, this.rawValue(), 8192);
        }

        public boolean dbcsesc() {
            return Util.ConvertFlag(this.data, this.rawValue(), 4096);
        }

        public static SystemFeatures create(byte[] Data2, int offset, int length) {
            return new SystemFeatures(Data2, offset, length);
        }
    }

    public static enum NameType {
        NOT_SPECIFIED(0),
        SYSTEM(1),
        SYSTEM_GROUP(2),
        NOT_DEFINED(-16);

        private static Map<Integer, NameType> valueMap;
        private final transient int basenametype;

        private NameType(int basenametype) {
            this.basenametype = basenametype;
        }

        public static NameType from(int value) {
            NameType result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int basenametype() {
            return this.basenametype;
        }

        static {
            valueMap = new HashMap<Integer, NameType>();
            for (NameType x : NameType.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.basenametype, x);
            }
        }
    }

    public static final class SystemInformation
    extends Data {
        private SystemInformation(byte[] Data2, int offset, int length) {
            super(Data2, offset, length);
        }

        public String dbcsysnm() {
            return Util.ConvertEbcdic(this.data, 0, 8);
        }

        public SystemFeatures dbcsysft() {
            return SystemFeatures.create(this.data, 8, 2);
        }

        public int dbcsysftRawValue() {
            return Util.ConvertUnsignedBinary2(this.data, 8);
        }

        public NameType dbcsnmty() {
            int value = Util.ConvertUnsignedBinary1(this.data, 12);
            return NameType.from(value);
        }

        public int dbcsnmtyRawValue() {
            return Util.ConvertUnsignedBinary1(this.data, 12);
        }

        public static SystemInformation create(byte[] Data2, int offset, int length) {
            return new SystemInformation(Data2, offset, length);
        }

        static enum Field {
            dbcsysnm(0, 8),
            dbcsysft(8, 2),
            dbcsnmty(12, 1);

            private final int offset;
            private final int length;

            private Field(int offset, int length) {
                this.offset = offset;
                this.length = length;
            }

            private Field() {
                this.offset = 0;
                this.length = 0;
            }

            int offset() {
                return this.offset;
            }

            int length() {
                return this.length;
            }
        }
    }
}

