/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import java.util.HashMap;
import java.util.Map;

public enum DcollectType {
    D("ActiveDataset"),
    A("VsamAssociation"),
    V("Volume"),
    M("MigratedDataset"),
    B("BackupDataset"),
    C("DasdCapacityPlanning"),
    T("TapeCapacityPlanning"),
    DC("DataClass"),
    SC("StorageClass"),
    MC("ManagementClass"),
    BC("BaseConfiguration"),
    SG("StorageGroup"),
    VL("SmsVolume"),
    AG("AggregateGroup"),
    DR("DriveDefinition"),
    LB("LibraryDefinition"),
    CN("CacheNames"),
    AI("AccountingInformation"),
    NOT_DEFINED("NotRecognized");

    private final transient String friendlyName;
    private static Map<String, DcollectType> valueMap;

    private DcollectType(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String toString() {
        return this.friendlyName;
    }

    public static DcollectType from(String value) {
        DcollectType result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    static {
        valueMap = new HashMap<String, DcollectType>();
        for (DcollectType x : DcollectType.values()) {
            valueMap.put(x.name(), x);
        }
    }
}

