/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SmsVolume
extends DcollectRecord {
    public static final int DVLCONV = 128;
    public static final int DVL32NAM = 128;
    private List<Status> m_dvlnstat = null;
    private List<Status> m_dvlsstat = null;

    SmsVolume(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.VL)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    SmsVolume(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.VL)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static SmsVolume from(VRecord record) {
        return new SmsVolume(record);
    }

    public String dvlvser() {
        return Util.ConvertEbcdic(this.data, 26, 6);
    }

    public String dvluser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dvldate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dvldateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime dvltime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String dvltimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public int dvlflags() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    public boolean dvlconv() {
        return Util.ConvertFlag(this.data, this.dvlflags(), 128);
    }

    public int dvlflgdc() {
        return Util.ConvertUnsignedBinary1(this.data, 85);
    }

    public boolean dvl32nam() {
        return Util.ConvertFlag(this.data, this.dvlflgdc(), 128);
    }

    private int dvlsglen() {
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public String dvlstgrp() {
        if (this.data.length >= 90 + this.dvlsglen()) {
            return Util.ConvertEbcdic(this.data, 90, this.dvlsglen());
        }
        return null;
    }

    public List<Status> dvlnstat() {
        if (this.m_dvlnstat != null) {
            return this.m_dvlnstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(new Status(SmsStatus.from(Util.ConvertUnsignedBinary1(this.data, 120 + i * 2)), MvsStatus.from(Util.ConvertUnsignedBinary1(this.data, 121 + i * 2)), SmsStatus.from(Util.ConvertUnsignedBinary1(this.data, 136 + i * 1))));
        }
        this.m_dvlnstat = result;
        return this.m_dvlnstat;
    }

    public long dvlnucba() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public long dvlntcpy() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public long dvlnfree() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long dvlnlext() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public int dvln0cnt() {
        return Util.ConvertSignedBinary2(this.data, 160);
    }

    public int dvltrksz() {
        return Util.ConvertUnsignedBinary2(this.data, 162);
    }

    public int dvlnlevl() {
        return Util.ConvertSignedBinary4(this.data, 164);
    }

    public List<Status> dvlsstat() {
        if (this.m_dvlsstat != null) {
            return this.m_dvlsstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(8);
        for (int i = 0; i < 32; ++i) {
            result.add(new Status(SmsStatus.from(Util.ConvertUnsignedBinary1(this.data, 168 + i * 8)), MvsStatus.from(Util.ConvertUnsignedBinary1(this.data, 169 + i * 8)), SmsStatus.from(Util.ConvertUnsignedBinary1(this.data, 170 + i * 8))));
        }
        this.m_dvlsstat = result;
        return this.m_dvlsstat;
    }

    public long dvltrkcp() {
        return Util.ConvertUnsignedBinary4(this.data, 424);
    }

    public long dvltrkfr() {
        return Util.ConvertUnsignedBinary4(this.data, 428);
    }

    public long dvltrkex() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    public static final class Status
    extends Data {
        private transient SmsStatus smsStatus;
        private transient MvsStatus mvsStatus;
        private transient SmsStatus confirmedSmsStatus;

        Status(SmsStatus status, MvsStatus mvsStatus, SmsStatus confirmedStatus) {
            super(null);
            this.smsStatus = status;
            this.mvsStatus = mvsStatus;
            this.confirmedSmsStatus = confirmedStatus;
        }

        public SmsStatus smsStatus() {
            return this.smsStatus;
        }

        public MvsStatus mvsStatus() {
            return this.mvsStatus;
        }

        public SmsStatus confirmedSmsStatus() {
            return this.confirmedSmsStatus;
        }
    }

    public static enum SmsStatus {
        NOT_SPECIFIED(0),
        ENABLED(1),
        QUIESCED_ALL(2),
        QUIESCED_NEW(3),
        DISABLED_ALL(4),
        DISABLED_NEW(5),
        NOT_DEFINED(-16);

        private static Map<Integer, SmsStatus> valueMap;
        private final transient int vlsmsstatus;

        private SmsStatus(int vlsmsstatus) {
            this.vlsmsstatus = vlsmsstatus;
        }

        public static SmsStatus from(int value) {
            SmsStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int vlsmsstatus() {
            return this.vlsmsstatus;
        }

        static {
            valueMap = new HashMap<Integer, SmsStatus>();
            for (SmsStatus x : SmsStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.vlsmsstatus, x);
            }
        }
    }

    public static enum MvsStatus {
        NULL(0),
        ONLINE(1),
        OFFLINE(2),
        PENDING_OFFLINE(3),
        BOXED(4),
        NOT_READY(5),
        READ_ONLY(6),
        NOT_DEFINED(-16);

        private static Map<Integer, MvsStatus> valueMap;
        private final transient int vlmvsstatus;

        private MvsStatus(int vlmvsstatus) {
            this.vlmvsstatus = vlmvsstatus;
        }

        public static MvsStatus from(int value) {
            MvsStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int vlmvsstatus() {
            return this.vlmvsstatus;
        }

        static {
            valueMap = new HashMap<Integer, MvsStatus>();
            for (MvsStatus x : MvsStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.vlmvsstatus, x);
            }
        }
    }

    static enum Field {
        dvlvser(26, 6),
        dvluser(56, 8),
        dvldate(64, 10),
        dvltime(76, 8),
        dvlflags(84, 1),
        dvlflgdc(85, 1),
        dvlsglen(88, 2),
        dvlstgrp(90, 0),
        dvlnstat(120, 16),
        dvlsmss(120, 1),
        dvlmvss(121, 1),
        dvlcsmss(136, 1),
        dvlnucba(144, 4),
        dvlntcpy(148, 4),
        dvlnfree(152, 4),
        dvlnlext(156, 4),
        dvln0cnt(160, 2),
        dvltrksz(162, 2),
        dvlnlevl(164, 4),
        dvlsstat(168, 256),
        dvltrkcp(424, 4),
        dvltrkfr(428, 4),
        dvltrkex(432, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

