/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StorageGroup
extends DcollectRecord {
    public static final int DSGFABUP = 128;
    public static final int DSGFAMIG = 64;
    public static final int DSGFADMP = 32;
    public static final int DSGFTHRS = 16;
    public static final int DSGFGBKU = 8;
    public static final int DSGGBNOL = 4;
    public static final int DSGFIMIG = 2;
    public static final int DSGFPSM = 1;
    public static final int DSG32NAM = 128;
    private List<String> m_dsgdmpcl = null;
    private List<Status> m_dsgfprst = null;
    public static final int DSGFCYS = 128;
    public static final int DSGFVLFT = 64;
    public static final int DSGFDRST = 32;
    public static final int DSGVFFER = 16;
    public static final int DSGVFERR = 8;
    public static final int DSGFRETP = 4;
    public static final int DSGFDELP = 2;
    private List<Library> m_dsgolibs = null;
    private List<Status> m_dsgsstat = null;
    public static final int DSGFLOWF = 128;
    public static final int DSGEXNMF = 64;
    public static final int DSGEAVBP = 16;

    StorageGroup(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.SG)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    StorageGroup(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.SG)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static StorageGroup from(VRecord record) {
        return new StorageGroup(record);
    }

    private int dsgnmlen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public String dsgname() {
        if (this.data.length >= 26 + this.dsgnmlen()) {
            return Util.ConvertEbcdic(this.data, 26, this.dsgnmlen());
        }
        return null;
    }

    public String dsguser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dsgdate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dsgdateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime dsgtime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String dsgtimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String dsgdesc() {
        return Util.ConvertEbcdic(this.data, 84, 120);
    }

    public int dsgflags() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public boolean dsgfabup() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 128);
    }

    public boolean dsgfamig() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 64);
    }

    public boolean dsgfadmp() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 32);
    }

    public boolean dsgfthrs() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 16);
    }

    public boolean dsgfgbku() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 8);
    }

    public boolean dsggbnol() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 4);
    }

    public boolean dsgfimig() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 2);
    }

    public boolean dsgfpsm() {
        return Util.ConvertFlag(this.data, this.dsgflags(), 1);
    }

    public int dsgflgdc() {
        return Util.ConvertUnsignedBinary1(this.data, 205);
    }

    public boolean dsg32nam() {
        return Util.ConvertFlag(this.data, this.dsgflgdc(), 128);
    }

    public StorageGroupType dsgftype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 208);
        return StorageGroupType.from(value);
    }

    public int dsgftypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 208);
    }

    public int dsgfhthr() {
        return Util.ConvertUnsignedBinary1(this.data, 209);
    }

    public int dsgflthr() {
        return Util.ConvertUnsignedBinary1(this.data, 210);
    }

    public int dsgfvmax() {
        return Util.ConvertSignedBinary4(this.data, 212);
    }

    public String dsgfvunt() {
        return Util.ConvertEbcdic(this.data, 216, 4);
    }

    public List<String> dsgdmpcl() {
        if (this.m_dsgdmpcl != null) {
            return this.m_dsgdmpcl;
        }
        ArrayList<String> result = new ArrayList<String>(5);
        for (int i = 0; i < 5; ++i) {
            result.add(Util.ConvertEbcdic(this.data, 220 + i * 8, 8));
        }
        this.m_dsgdmpcl = result;
        return this.m_dsgdmpcl;
    }

    public List<Status> dsgfprst() {
        if (this.m_dsgfprst != null) {
            return this.m_dsgfprst;
        }
        ArrayList<Status> result = new ArrayList<Status>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(new Status(StorageGroupStatus.from(Util.ConvertUnsignedBinary1(this.data, 260 + i * 1)), StorageGroupStatus.from(Util.ConvertUnsignedBinary1(this.data, 292 + i * 1))));
        }
        this.m_dsgfprst = result;
        return this.m_dsgfprst;
    }

    public StorageGroupStatus dsgstat() {
        int value = Util.ConvertUnsignedBinary1(this.data, 260);
        return StorageGroupStatus.from(value);
    }

    public int dsgstatRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 260);
    }

    public String dsgabsys() {
        return Util.ConvertEbcdic(this.data, 268, 8);
    }

    public String dsgadsys() {
        return Util.ConvertEbcdic(this.data, 276, 8);
    }

    public String dsgamsys() {
        return Util.ConvertEbcdic(this.data, 284, 8);
    }

    public int dsggbkuf() {
        return Util.ConvertSignedBinary4(this.data, 300);
    }

    public String dsgtblgr() {
        return Util.ConvertEbcdic(this.data, 304, 8);
    }

    public int dsgoamfl() {
        return Util.ConvertUnsignedBinary1(this.data, 312);
    }

    public boolean dsgfcys() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 128);
    }

    public boolean dsgfvlft() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 64);
    }

    public boolean dsgfdrst() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 32);
    }

    public boolean dsgvffer() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 16);
    }

    public boolean dsgvferr() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 8);
    }

    public boolean dsgfretp() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 4);
    }

    public boolean dsgfdelp() {
        return Util.ConvertFlag(this.data, this.dsgoamfl(), 2);
    }

    public int dsgcylst() {
        return Util.ConvertUnsignedBinary1(this.data, 314);
    }

    public int dsgcyled() {
        return Util.ConvertUnsignedBinary1(this.data, 315);
    }

    public int dsgvolft() {
        return Util.ConvertUnsignedBinary2(this.data, 316);
    }

    public int dsgdrvst() {
        return Util.ConvertUnsignedBinary2(this.data, 318);
    }

    public List<Library> dsgolibs() {
        if (this.m_dsgolibs != null) {
            return this.m_dsgolibs;
        }
        ArrayList<Library> result = new ArrayList<Library>();
        for (int i = 0; i < 8; ++i) {
            Library ol = Library.create(this.data, 320 + i * 32, 32);
            if (ol.dsgolbnl() <= 0) continue;
            result.add(ol);
        }
        this.m_dsgolibs = result;
        return this.m_dsgolibs;
    }

    public List<Status> dsgsstat() {
        if (this.m_dsgsstat != null) {
            return this.m_dsgsstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(32);
        for (int i = 0; i < 32; ++i) {
            result.add(new Status(StorageGroupStatus.from(Util.ConvertUnsignedBinary1(this.data, 576 + i * 8)), StorageGroupStatus.from(Util.ConvertUnsignedBinary1(this.data, 577 + i * 8))));
        }
        this.m_dsgsstat = result;
        return this.m_dsgsstat;
    }

    public int dsgoflow() {
        return Util.ConvertUnsignedBinary1(this.data, 848);
    }

    private int dsgexnln() {
        return Util.ConvertUnsignedBinary2(this.data, 849);
    }

    public String dsgexnm() {
        if (this.data.length >= 851 + this.dsgexnln()) {
            return Util.ConvertEbcdic(this.data, 851, this.dsgexnln());
        }
        return null;
    }

    public int dsgflag2() {
        return Util.ConvertUnsignedBinary1(this.data, 883);
    }

    public boolean dsgflowf() {
        return Util.ConvertFlag(this.data, this.dsgflag2(), 128);
    }

    public boolean dsgexnmf() {
        return Util.ConvertFlag(this.data, this.dsgflag2(), 64);
    }

    public boolean dsgeavbp() {
        return Util.ConvertFlag(this.data, this.dsgflag2(), 16);
    }

    public long dsgsbkpt() {
        return Util.ConvertUnsignedBinary4(this.data, 884);
    }

    public int dsgshthr() {
        return Util.ConvertUnsignedBinary2(this.data, 888);
    }

    public int dsgslthr() {
        return Util.ConvertUnsignedBinary2(this.data, 890);
    }

    public int dsgtotap() {
        return Util.ConvertUnsignedBinary1(this.data, 916);
    }

    public int dsgtmsap() {
        return Util.ConvertUnsignedBinary1(this.data, 917);
    }

    public String dsgoamid() {
        return Util.ConvertEbcdic(this.data, 918, 4);
    }

    public static enum StorageGroupType {
        POOL(0),
        VIO(1),
        DUMMY(2),
        OBJECT(3),
        OBJECT_BACKUP(4),
        TAPE(5),
        COPY_TARGET(6),
        NOT_DEFINED(-16);

        private static Map<Integer, StorageGroupType> valueMap;
        private final transient int sgtype;

        private StorageGroupType(int sgtype) {
            this.sgtype = sgtype;
        }

        public static StorageGroupType from(int value) {
            StorageGroupType result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int sgtype() {
            return this.sgtype;
        }

        static {
            valueMap = new HashMap<Integer, StorageGroupType>();
            for (StorageGroupType x : StorageGroupType.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.sgtype, x);
            }
        }
    }

    public static final class Status
    extends Data {
        private transient StorageGroupStatus status;
        private transient StorageGroupStatus confirmedStatus;

        Status(StorageGroupStatus status, StorageGroupStatus confirmedStatus) {
            super(null);
            this.status = status;
            this.confirmedStatus = confirmedStatus;
        }

        public StorageGroupStatus status() {
            return this.status;
        }

        public StorageGroupStatus confirmedStatus() {
            return this.confirmedStatus;
        }
    }

    public static enum StorageGroupStatus {
        NOT_SPECIFIED(0),
        ENABLED(1),
        QUIESCED_ALL(2),
        QUIESCED_NEW(3),
        DISABLED_ALL(4),
        DISABLED_NEW(5),
        NOT_DEFINED(-16);

        private static Map<Integer, StorageGroupStatus> valueMap;
        private final transient int sgstatus;

        private StorageGroupStatus(int sgstatus) {
            this.sgstatus = sgstatus;
        }

        public static StorageGroupStatus from(int value) {
            StorageGroupStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int sgstatus() {
            return this.sgstatus;
        }

        static {
            valueMap = new HashMap<Integer, StorageGroupStatus>();
            for (StorageGroupStatus x : StorageGroupStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.sgstatus, x);
            }
        }
    }

    public static final class Library
    extends Data {
        private Library(byte[] Data2, int offset, int length) {
            super(Data2, offset, length);
        }

        public int dsgolbnl() {
            return Util.ConvertUnsignedBinary2(this.data, 0);
        }

        public String dsgolbnm() {
            if (this.data.length >= 2 + this.dsgolbnl()) {
                return Util.ConvertEbcdic(this.data, 2, this.dsgolbnl());
            }
            return null;
        }

        @Override
        public String toString() {
            return this.dsgolbnm();
        }

        static Library create(byte[] Data2, int offset, int length) {
            return new Library(Data2, offset, length);
        }

        static enum Field {
            dsgolbnl(0, 2),
            dsgolbnm(2, 0);

            private final int offset;
            private final int length;

            private Field(int offset, int length) {
                this.offset = offset;
                this.length = length;
            }

            private Field() {
                this.offset = 0;
                this.length = 0;
            }

            int offset() {
                return this.offset;
            }

            int length() {
                return this.length;
            }
        }
    }

    static enum Field {
        dsgnmlen(24, 2),
        dsgname(26, 0),
        dsguser(56, 8),
        dsgdate(64, 10),
        dsgtime(76, 8),
        dsgdesc(84, 120),
        dsgflags(204, 1),
        dsgflgdc(205, 1),
        dsgftype(208, 1),
        dsgfhthr(209, 1),
        dsgflthr(210, 1),
        dsgfvmax(212, 4),
        dsgfvunt(216, 4),
        dsgdmpcl(220, 8),
        dsgfprst(260, 1),
        dsgstat(260, 1),
        dsgabsys(268, 8),
        dsgadsys(276, 8),
        dsgamsys(284, 8),
        dsgcnfrm(292, 1),
        dsgcsmss(292, 1),
        dsggbkuf(300, 4),
        dsgtblgr(304, 8),
        dsgoamfl(312, 1),
        dsgcylst(314, 1),
        dsgcyled(315, 1),
        dsgvolft(316, 2),
        dsgdrvst(318, 2),
        dsgolibs(320, 32),
        dsgsstat(576, 8),
        dsgoflow(848, 1),
        dsgexnln(849, 2),
        dsgexnm(851, 0),
        dsgflag2(883, 1),
        dsgsbkpt(884, 4),
        dsgshthr(888, 2),
        dsgslthr(890, 2),
        dsgtotap(916, 1),
        dsgtmsap(917, 1),
        dsgoamid(918, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

