/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.values.Recorg;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;

public final class VsamAssociation
extends DcollectRecord {
    public static final int DCAKSDS = 128;
    public static final int DCAESDS = 64;
    public static final int DCARRDS = 32;
    public static final int DCALDS = 16;
    public static final int DCAKRDS = 8;
    public static final int DCAAIX = 4;
    public static final int DCADATA = 2;
    public static final int DCAINDEX = 1;
    public static final int DCAKR1ST = 128;
    public static final int DCAIXUPG = 64;
    public static final int DCAVRRDS = 32;
    public static final int DCANSTAT = 16;
    public static final int DCASRCI = 8;
    public static final int DCAG4G = 4;
    public static final int DCAZFS = 2;

    VsamAssociation(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.A)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    VsamAssociation(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.A)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static VsamAssociation from(VRecord record) {
        return new VsamAssociation(record);
    }

    public String dcadsnam() {
        return Util.ConvertEbcdic(this.data, 24, 44);
    }

    public String dcaassoc() {
        return Util.ConvertEbcdic(this.data, 68, 44);
    }

    public int dcaflag1() {
        return Util.ConvertUnsignedBinary1(this.data, 112);
    }

    public Recorg recorg() {
        int value = this.dcaflag1() & 0xF0;
        switch (value) {
            case 128: {
                return Recorg.KSDS;
            }
            case 64: {
                return Recorg.ESDS;
            }
            case 32: {
                return Recorg.RRDS;
            }
            case 16: {
                return Recorg.LDS;
            }
            case 0: {
                return Recorg.NULL;
            }
        }
        return Recorg.NOT_DEFINED;
    }

    public boolean dcaksds() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 128);
    }

    public boolean dcaesds() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 64);
    }

    public boolean dcarrds() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 32);
    }

    public boolean dcalds() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 16);
    }

    public boolean dcakrds() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 8);
    }

    public boolean dcaaix() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 4);
    }

    public boolean dcadata() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 2);
    }

    public boolean dcaindex() {
        return Util.ConvertFlag(this.data, this.dcaflag1(), 1);
    }

    public int dcaflag2() {
        return Util.ConvertUnsignedBinary1(this.data, 113);
    }

    public boolean dcakr1st() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 128);
    }

    public boolean dcaixupg() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 64);
    }

    public boolean dcavrrds() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 32);
    }

    public boolean dcanstat() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 16);
    }

    public boolean dcasrci() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 8);
    }

    public boolean dcag4g() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 4);
    }

    public boolean dcazfs() {
        return Util.ConvertFlag(this.data, this.dcaflag2(), 2);
    }

    public long dcahurba() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long dcaharba() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public int dcanlr() {
        return Util.ConvertSignedBinary4(this.data, 124);
    }

    public int dcadlr() {
        return Util.ConvertSignedBinary4(this.data, 128);
    }

    public int dcainr() {
        return Util.ConvertSignedBinary4(this.data, 132);
    }

    public int dcaupr() {
        return Util.ConvertSignedBinary4(this.data, 136);
    }

    public int dcartr() {
        return Util.ConvertSignedBinary4(this.data, 140);
    }

    public int dcaasp() {
        return Util.ConvertSignedBinary4(this.data, 144);
    }

    public int dcacis() {
        return Util.ConvertSignedBinary4(this.data, 148);
    }

    public int dcacas() {
        return Util.ConvertSignedBinary4(this.data, 152);
    }

    public int dcaexc() {
        return Util.ConvertSignedBinary4(this.data, 156);
    }

    public int dcarkp() {
        return Util.ConvertSignedBinary2(this.data, 160);
    }

    public int dcakln() {
        return Util.ConvertSignedBinary2(this.data, 162);
    }

    public long dcahurbc() {
        return Util.ConvertUnsignedBinary8(this.data, 164);
    }

    public BigInteger dcahurbcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 164);
    }

    public long dcaharbc() {
        return Util.ConvertUnsignedBinary8(this.data, 172);
    }

    public BigInteger dcaharbcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 172);
    }

    public int dcacisz() {
        return Util.ConvertSignedBinary4(this.data, 180);
    }

    public int dcacaci() {
        return Util.ConvertSignedBinary4(this.data, 184);
    }

    public LocalDate dcatrdt() {
        return Util.Packed4YYYYDDD(this.data, 188);
    }

    public int dcatrdtRawValue() {
        return Util.ConvertPacked4(this.data, 188);
    }

    static enum Field {
        dcadsnam(24, 44),
        dcaassoc(68, 44),
        dcaflag1(112, 1),
        dcaflag2(113, 1),
        dcahurba(116, 4),
        dcaharba(120, 4),
        dcanlr(124, 4),
        dcadlr(128, 4),
        dcainr(132, 4),
        dcaupr(136, 4),
        dcartr(140, 4),
        dcaasp(144, 4),
        dcacis(148, 4),
        dcacas(152, 4),
        dcaexc(156, 4),
        dcarkp(160, 2),
        dcakln(162, 2),
        dcahurbc(164, 8),
        dcaharbc(172, 8),
        dcacisz(180, 4),
        dcacaci(184, 4),
        dcatrdt(188, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

