/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

class ByteArrayRecordReader
extends VRecordReader {
    private Iterator<byte[]> source;

    ByteArrayRecordReader(Iterable<byte[]> source) {
        this.source = source.iterator();
    }

    @Override
    public synchronized VRecord read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader has been closed");
        }
        if (this.source.hasNext()) {
            return new VRecord(this.source.next());
        }
        return null;
    }

    @Override
    public synchronized int read(byte[] dest) throws IOException {
        if (this.closed) {
            throw new IOException("Reader has been closed");
        }
        if (this.source.hasNext()) {
            byte[] record = this.source.next();
            if (record.length > dest.length) {
                throw new IOException("Dest buffer too small, size: " + Integer.toString(dest.length) + " source length " + Integer.toString(record.length));
            }
            System.arraycopy(record, 0, dest, 0, record.length);
            return record.length;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                if (this.source instanceof Closeable) {
                    Closeable closeable = (Closeable)((Object)this.source);
                    closeable.close();
                }
            }
        }
    }
}

