/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.VRecordReader;
import com.blackhillsoftware.smf.internal.Util;
import com.ibm.jzos.JFCB;
import com.ibm.jzos.RcException;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JzosRecordReader
extends VRecordReader {
    private RecordReader recordreader = null;
    private byte[] workdata = new byte[32768];

    public static JzosRecordReader fromDD(String dd) throws IOException {
        try {
            boolean subsys = false;
            JFCB jfcb = ZFile.readJFCB((String)dd);
            if ((jfcb.getJfcbtsdm() & 0x20) == 32) {
                Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
                slf4jLogger.info("Subsystem DD detected, setting jzos.bsam.disable=true");
                System.setProperty("jzos.bsam.disable", "true");
                subsys = true;
            }
            RecordReader reader = RecordReader.newReaderForDD((String)dd);
            if (subsys && reader.getLrecl() < 32756) {
                throw new IOException("Invalid LRECL for SMF data subsystem: " + reader.getLrecl() + ". SMF data requires 32756 minimum.");
            }
            return new JzosRecordReader(reader);
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
                slf4jLogger.error("Error trying to open DDNAME " + dd);
                slf4jLogger.error("This error is expected if trying to read from a DDNAME on a non-z/OS system.");
            }
            throw e;
        }
    }

    public static JzosRecordReader fromLogstream(String lsName, String options1, String options2) throws IOException {
        try {
            String ddname = ZFile.allocDummyDDName();
            String options = "";
            if (options1 != null && options2 == null) {
                options = "," + options1;
            } else if (options1 == null && options2 != null) {
                options = ",," + options2;
            } else if (options1 != null && options2 != null) {
                options = "," + options1 + "," + options2;
            }
            String cmd = String.format("alloc fi(%s) da(%s) lrecl(32756) blksize(32760) subsys(LOGR,IFASEXIT%s) reuse close", ddname, lsName, options);
            try {
                ZFile.bpxwdyn((String)cmd);
            }
            catch (RcException e) {
                throw new IOException("Logstream allocation failed: " + System.lineSeparator() + " " + cmd, e);
            }
            System.setProperty("jzos.bsam.disable", "true");
            return new JzosRecordReader(RecordReader.newReaderForDD((String)ddname));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
                slf4jLogger.error("Error trying to open logstream " + lsName);
                slf4jLogger.error("This error is expected if trying to read from a DDNAME on a non-z/OS system.");
            }
            throw e;
        }
    }

    public static JzosRecordReader fromDatasetName(String name) throws IOException {
        try {
            return new JzosRecordReader(RecordReader.newReader((String)name, (int)1));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger(SmfRecord.class);
                slf4jLogger.error("Error trying to open dataset " + name);
                slf4jLogger.error("This error is expected if trying to read from a dataset on a non-z/OS system.");
            }
            throw e;
        }
    }

    @Override
    public synchronized int read(byte[] buffer) throws IOException {
        if (this.closed) {
            throw new IOException("Reader has been closed");
        }
        if (this.eof) {
            return -1;
        }
        int nRead = this.recordreader.read(buffer, 4, buffer.length - 4);
        if (nRead < 0) {
            this.eof = true;
            return -1;
        }
        int recordlength = nRead + 4;
        Util.WriteUnsignedBinary2(buffer, 0, recordlength);
        Util.WriteUnsignedBinary2(buffer, 2, 0);
        return recordlength;
    }

    @Override
    public synchronized VRecord read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader has been closed");
        }
        int bytesread = 0;
        bytesread = this.read(this.workdata);
        if (bytesread > 0) {
            return new VRecord(Arrays.copyOfRange(this.workdata, 0, bytesread));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                if (this.recordreader != null) {
                    this.recordreader.close();
                }
            }
        }
    }

    private JzosRecordReader(RecordReader aRecordReader) {
        this.recordreader = aRecordReader;
    }
}

