/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.RecordReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class VRecordReaderIterator<T extends Data>
implements Iterator<T> {
    private final ThreadLocal<T> next = new ThreadLocal();
    private RecordReader<T> source;

    VRecordReaderIterator(RecordReader<T> source) {
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        if (this.next.get() != null) {
            return true;
        }
        try {
            T record = this.source.read();
            if (record != null) {
                this.next.set(record);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading next record", e);
        }
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            Data result = (Data)this.next.get();
            this.next.remove();
            return (T)result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

