/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class MnHeader
extends SmfData {
    private MnHeader(byte[] data) {
        super(data);
    }

    public LocalTime smfmntme() {
        return Util.Binary4x100STime(this.data, 6 - Field.smfmntme.offset());
    }

    public long smfmntmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6 - Field.smfmntme.offset());
    }

    public LocalDate smfmndte() {
        return Util.SMFDate(this.data, 10 - Field.smfmntme.offset());
    }

    public int smfmndteRawValue() {
        return Util.ConvertPacked4(this.data, 10 - Field.smfmntme.offset());
    }

    public String smfmnsid() {
        return Util.ConvertEbcdic(this.data, 14 - Field.smfmntme.offset(), 4);
    }

    public String smfmnssi() {
        return Util.ConvertEbcdic(this.data, 18 - Field.smfmntme.offset(), 4);
    }

    public static MnHeader create(Smf110Record r110) {
        return new MnHeader(r110.getBytes(Field.smfmntme.offset(), Field.smfmnssi.offset() + Field.smfmnssi.length() - Field.smfmntme.offset()));
    }

    static enum Field {
        smfmntme(6, 4),
        smfmndte(10, 4),
        smfmnsid(14, 4),
        smfmnssi(18, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

