/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public final class MnProductSection
extends SmfData {
    public static final int SMFMNAPL = 128;
    public static final int SMFMNRMI = 64;
    public static final int SMFMNCMP = 32;

    private MnProductSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smfmnrvn() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public String smfmnprn() {
        return Util.ConvertEbcdic(this.data, 2, 8);
    }

    public String smfmnspn() {
        return Util.ConvertEbcdic(this.data, 10, 8);
    }

    public int smfmnmfl() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public int smfmncl() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public boolean monitoringClassDictionary() {
        return Util.ConvertEquateValue(this.data, this.smfmncl(), 1);
    }

    public boolean monitoringClassPerformance() {
        return Util.ConvertEquateValue(this.data, this.smfmncl(), 3);
    }

    public boolean monitoringClassException() {
        return Util.ConvertEquateValue(this.data, this.smfmncl(), 4);
    }

    public boolean monitoringClassResource() {
        return Util.ConvertEquateValue(this.data, this.smfmncl(), 5);
    }

    public boolean monitoringClassIdentity() {
        return Util.ConvertEquateValue(this.data, this.smfmncl(), 6);
    }

    public int smfmndca() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int smfmndcl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smfmndcn() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smfmndra() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int smfmndrl() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smfmndrn() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public int smfmncrl() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    void clearCompression() {
        Util.WriteUnsignedBinary2(this.data, 58, 0);
    }

    public ZoneOffset smfmntad() {
        return Util.Binary4_CVTTZ(this.data, 60);
    }

    public int smfmntadRawValue() {
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public Duration smfmnlso() {
        return Util.Binary8StckInterval(this.data, 64);
    }

    public double smfmnlsoSeconds() {
        return Util.ToSeconds(this.smfmnlso());
    }

    public long smfmnlsoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 64);
    }

    public ZoneOffset smfmndto() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 72);
    }

    public long smfmndtoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 72);
    }

    public int smfmnopn() {
        return Util.ConvertUnsignedBinary1(this.data, 81);
    }

    public boolean smfmnapl() {
        return Util.ConvertFlag(this.data, this.smfmnopn(), 128);
    }

    public boolean smfmnrmi() {
        return Util.ConvertFlag(this.data, this.smfmnopn(), 64);
    }

    public boolean smfmncmp() {
        return Util.ConvertFlag(this.data, this.smfmnopn(), 32);
    }

    public String smfmnjbn() {
        return Util.ConvertEbcdic(this.data, 82, 8);
    }

    public LocalDate smfmnrsd() {
        return Util.SMFDate(this.data, 90);
    }

    public int smfmnrsdRawValue() {
        return Util.ConvertPacked4(this.data, 90);
    }

    public LocalTime smfmnrst() {
        return Util.Binary4x100STime(this.data, 94);
    }

    public long smfmnrstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 94);
    }

    public String smfmnuif() {
        return Util.ConvertEbcdic(this.data, 98, 8);
    }

    public String smfmnpdn() {
        return Util.ConvertEbcdic(this.data, 106, 8);
    }

    public static MnProductSection create(byte[] Data2, int offset, int length) {
        return new MnProductSection(Data2, offset, length);
    }

    static enum Field {
        smfmnrvn(0, 2),
        smfmnprn(2, 8),
        smfmnspn(10, 8),
        smfmnmfl(18, 2),
        smfmncl(22, 2),
        smfmndca(24, 4),
        smfmndcl(28, 2),
        smfmndcn(30, 2),
        smfmndra(32, 4),
        smfmndrl(36, 2),
        smfmndrn(38, 2),
        smfmncrl(58, 2),
        smfmntad(60, 4),
        smfmnlso(64, 8),
        smfmndto(72, 8),
        smfmnopn(81, 1),
        smfmnjbn(82, 8),
        smfmnrsd(90, 4),
        smfmnrst(94, 4),
        smfmnuif(98, 8),
        smfmnpdn(106, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

