/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.cics.CicsInstanceId;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryException;
import com.blackhillsoftware.smf.cics.monitoring.fields.ByteStringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import com.blackhillsoftware.smf.cics.monitoring.fields.CountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.MultiCountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.PackedField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TimestampField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TrannumField;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class Dictionary {
    private transient Map<MonitoringField, DictionaryEntry> dictionaryEntries = new HashMap<MonitoringField, DictionaryEntry>();
    private transient Map<Integer, DictionaryEntry> connectors;
    private transient Map<String, Map<String, DictionaryEntry>> identifiers;
    private List<DictionaryEntry> entries;
    private transient int hashcode;
    private transient CicsInstanceId cicsInstance;

    private Dictionary(List<DictionaryEntry> dictionaryEntries, CicsInstanceId cicsInstance) {
        this.entries = Collections.unmodifiableList(dictionaryEntries);
        this.connectors = new HashMap<Integer, DictionaryEntry>();
        this.identifiers = new HashMap<String, Map<String, DictionaryEntry>>();
        this.cicsInstance = cicsInstance;
        this.hashcode = 17;
        for (DictionaryEntry entry : this.entries) {
            this.hashcode = 31 * this.hashcode + entry.hashCode();
            this.connectors.put(entry.cmodconn(), entry);
            DictionaryEntry existing = this.identifiers.computeIfAbsent(entry.cmodname(), x -> new HashMap()).put(entry.cmodtype() + entry.cmodidnt(), entry);
            if (existing == null) continue;
            throw new RuntimeException("Duplicate Dictionary Entry");
        }
    }

    public static Dictionary create(List<DictionaryEntry> dictionaryEntries, CicsInstanceId cicsInstance) {
        return new Dictionary(dictionaryEntries, cicsInstance);
    }

    public DictionaryEntry getEntryByConnector(Integer connectorValue) {
        return this.connectors.get(connectorValue);
    }

    public DictionaryEntry getEntryByIdentifier(String owner, String identifier) {
        Map<String, DictionaryEntry> owned = this.identifiers.get(owner);
        if (owned != null) {
            return owned.get(identifier);
        }
        return null;
    }

    public boolean haveEntry(MonitoringField field) {
        if (field == null) {
            return false;
        }
        return this.getEntry(field, true) != null;
    }

    public DictionaryEntry getEntry(MonitoringField field) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        return this.getEntry(field, false);
    }

    private DictionaryEntry getEntry(MonitoringField field, Boolean noException) {
        DictionaryEntry result = this.dictionaryEntries.get(field);
        if (result == null) {
            result = this.findEntry(field);
            if (result == null && !noException.booleanValue()) {
                throw new NoSuchElementException("Dictionary Entry not found: " + field.getOwner() + " " + field.getIdentifier());
            }
            this.dictionaryEntries.put(field, result);
        }
        return result;
    }

    private DictionaryEntry findEntry(MonitoringField field) {
        DictionaryEntry entry;
        Map<String, DictionaryEntry> owner = this.identifiers.get(field.getOwner());
        if (owner != null && (entry = owner.get(field.getIdentifier())) != null) {
            this.checkFieldType(field, entry);
            return entry;
        }
        return null;
    }

    private void checkFieldType(MonitoringField field, DictionaryEntry entry) {
        switch (entry.cmodtype()) {
            case "A": {
                if (!(field instanceof CountField) && !(field instanceof MultiCountField)) {
                    throw new DictionaryException("Field type mismatch: " + entry.cmodname() + " " + entry.entryId() + " incorrect class: " + this.getClass().toString());
                }
                if (field instanceof MultiCountField) {
                    if (entry.cmodleng() % 8 == 0) break;
                    throw new DictionaryException("Invalid field length for MultiCountField: " + entry.cmodname() + " " + entry.entryId() + " " + Integer.toString(entry.cmodleng()));
                }
                if (entry.cmodleng() == 4 || entry.cmodleng() == 8) break;
                throw new DictionaryException("Invalid field length: " + entry.cmodname() + " " + entry.entryId() + " " + Integer.toString(entry.cmodleng()));
            }
            case "C": {
                if (field instanceof ByteStringField) break;
                throw new DictionaryException("Field type mismatch: " + entry.cmodname() + " " + entry.entryId() + " incorrect class: " + this.getClass().toString());
            }
            case "P": {
                if (!(field instanceof PackedField) && !(field instanceof TrannumField)) {
                    throw new DictionaryException("Field type mismatch: " + entry.cmodname() + " " + entry.entryId() + " incorrect class: " + this.getClass().toString());
                }
                if (entry.cmodleng() <= 31) break;
                throw new DictionaryException("Invalid field length: " + entry.cmodname() + " " + entry.entryId() + " " + Integer.toString(entry.cmodleng()));
            }
            case "S": {
                if (!(field instanceof ClockField)) {
                    throw new DictionaryException("Field type mismatch: " + entry.cmodname() + " " + entry.entryId() + " incorrect class: " + this.getClass().toString());
                }
                if (entry.cmodleng() == 12) break;
                throw new DictionaryException("Invalid field length: " + entry.cmodname() + " " + entry.entryId() + " " + Integer.toString(entry.cmodleng()));
            }
            case "T": {
                if (!(field instanceof TimestampField)) {
                    throw new DictionaryException("Field type mismatch: " + entry.cmodname() + " " + entry.entryId() + " incorrect class: " + this.getClass().toString());
                }
                if (entry.cmodleng() == 8) break;
                throw new DictionaryException("Invalid field length: " + entry.cmodname() + " " + entry.entryId() + " " + Integer.toString(entry.cmodleng()));
            }
        }
    }

    public List<DictionaryEntry> entries() {
        return this.entries;
    }

    @Deprecated
    public List<DictionaryEntry> Entries() {
        return this.entries;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dictionary other = (Dictionary)obj;
        return this.entries.equals(other.entries);
    }

    public CicsInstanceId getCicsInstance() {
        return this.cicsInstance;
    }
}

