/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.MniDataEntry;
import com.blackhillsoftware.smf.cics.monitoring.MniIdentificationData;
import com.blackhillsoftware.smf.internal.Util;
import java.util.List;

public final class IdentityRecord
extends SmfData {
    private List<MniIdentificationData> m_MniIdentificationData = null;
    private List<MniDataEntry> m_MniDataEntry = null;
    public static final int MNI_ID_EQUATE = 51;
    public static final int MNI_VERSION = 1;
    public static final int MNI_HDR_LENGTH = 32;

    private IdentityRecord(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public List<MniIdentificationData> identificationData() {
        this.m_MniIdentificationData = Util.sectionsFromTriplet(this.m_MniIdentificationData, this.data, () -> this.mniIso(), () -> this.mniIsl(), () -> this.mniIsn(), MniIdentificationData::create);
        return this.m_MniIdentificationData;
    }

    public List<MniDataEntry> dataEntries() {
        this.m_MniDataEntry = Util.sectionsFromTriplet(this.m_MniDataEntry, this.data, () -> this.mniDso(), () -> this.mniDsl(), () -> this.mniDsn(), MniDataEntry::create);
        return this.m_MniDataEntry;
    }

    public int mniLength() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mniId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mniDsectVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int mniHdrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int mniTrn() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int mniIso() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int mniIsl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int mniIsn() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int mniDso() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int mniDsl() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int mniDsn() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public static IdentityRecord create(byte[] Data2, int offset, int length) {
        return new IdentityRecord(Data2, offset, length);
    }

    static enum Field {
        mniLength(0, 2),
        mniId(2, 2),
        mniDsectVers(4, 1),
        mniHdrlen(8, 2),
        mniTrn(20, 2),
        mniIso(24, 4),
        mniIsl(28, 2),
        mniIsn(30, 2),
        mniDso(32, 4),
        mniDsl(36, 2),
        mniDsn(38, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

