/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZonedDateTime;

public final class MniIdentificationData
extends SmfData {
    public static final int MNI_ID_NATURE_NOTAPPLIC = 0;
    public static final int MNI_ID_NATURE_TERMINAL = 1;
    public static final int MNI_ID_NATURE_SESSION = 2;
    public static final int MNI_ID_SESSTYPE_NOTAPPLIC = 0;
    public static final int MNI_ID_SESSTYPE_IRC = 1;
    public static final int MNI_ID_SESSTYPE_IRC_XM = 2;
    public static final int MNI_ID_SESSTYPE_IRC_XCF = 3;
    public static final int MNI_ID_SESSTYPE_LU61 = 4;
    public static final int MNI_ID_SESSTYPE_LU62_SING = 5;
    public static final int MNI_ID_SESSTYPE_LU62_PARA = 6;
    public static final int MNI_ID_ACMETH_NOTAPPLIC = 0;
    public static final int MNI_ID_ACMETH_VTAM = 1;
    public static final int MNI_ID_ACMETH_BSAM = 3;
    public static final int MNI_ID_ACMETH_TCAM = 4;
    public static final int MNI_ID_ACMETH_BGAM = 6;
    public static final int MNI_ID_ACMETH_CONSOLE = 7;
    public static final int MNI_ID_LENGTH = 444;

    private MniIdentificationData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String mniIdTranid() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public String mniIdTermid() {
        return Util.ConvertEbcdic(this.data, 4, 4);
    }

    public String mniIdUserid() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String mniIdStype() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public ZonedDateTime mniIdStart() {
        return Util.Binary8xStckTime(this.data, 20);
    }

    public BigInteger mniIdStartRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 20);
    }

    public ZonedDateTime mniIdStop() {
        return Util.Binary8xStckTime(this.data, 28);
    }

    public BigInteger mniIdStopRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public long mniIdTaskno() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public String mniIdLuname() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String mniIdPgmname() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String mniIdUowPx() {
        return Util.ConvertEbcdic(this.data, 56, 20);
    }

    public String mniIdUowSx() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String mniIdRsysid() {
        return Util.ConvertEbcdic(this.data, 84, 4);
    }

    public long mniIdTrnFlags() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger mniIdTrnFlagsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public String mniIdFctyname() {
        return Util.ConvertEbcdic(this.data, 96, 4);
    }

    public String mniIdRtype() {
        return Util.ConvertEbcdic(this.data, 100, 4);
    }

    public long mniIdTerminfo() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public int mniIdNature() {
        return Util.ConvertUnsignedBinary1(this.data, 104);
    }

    public boolean mniIdNatureNotapplic() {
        return Util.ConvertEquateValue(this.data, this.mniIdNature(), 0);
    }

    public boolean mniIdNatureTerminal() {
        return Util.ConvertEquateValue(this.data, this.mniIdNature(), 1);
    }

    public boolean mniIdNatureSession() {
        return Util.ConvertEquateValue(this.data, this.mniIdNature(), 2);
    }

    public int mniIdSesstype() {
        return Util.ConvertUnsignedBinary1(this.data, 105);
    }

    public boolean mniIdSesstypeNotapplic() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 0);
    }

    public boolean mniIdSesstypeIrc() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 1);
    }

    public boolean mniIdSesstypeIrcXm() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 2);
    }

    public boolean mniIdSesstypeIrcXcf() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 3);
    }

    public boolean mniIdSesstypeLu61() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 4);
    }

    public boolean mniIdSesstypeLu62Sing() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 5);
    }

    public boolean mniIdSesstypeLu62Para() {
        return Util.ConvertEquateValue(this.data, this.mniIdSesstype(), 6);
    }

    public int mniIdAcmeth() {
        return Util.ConvertUnsignedBinary1(this.data, 106);
    }

    public boolean mniIdAcmethNotapplic() {
        return Util.ConvertEquateValue(this.data, this.mniIdAcmeth(), 0);
    }

    public boolean mniIdAcmethVtam() {
        return Util.ConvertEquateValue(this.data, this.mniIdAcmeth(), 1);
    }

    public boolean mniIdAcmethBsam() {
        return Util.ConvertEquateValue(this.data, this.mniIdAcmeth(), 3);
    }

    public boolean mniIdAcmethTcam() {
        return Util.ConvertEquateValue(this.data, this.mniIdAcmeth(), 4);
    }

    public boolean mniIdAcmethBgam() {
        return Util.ConvertEquateValue(this.data, this.mniIdAcmeth(), 6);
    }

    public boolean mniIdAcmethConsole() {
        return Util.ConvertEquateValue(this.data, this.mniIdAcmeth(), 7);
    }

    public int mniIdDevcode() {
        return Util.ConvertUnsignedBinary1(this.data, 107);
    }

    public String mniIdTermcnnm() {
        return Util.ConvertEbcdic(this.data, 108, 4);
    }

    public String mniIdIsipicnm() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public String mniIdClipaddr() {
        return Util.ConvertEbcdic(this.data, 140, 40);
    }

    public InetAddress mniIdClipaddrAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 140, 40);
    }

    public String mniIdOriginNetwkid() {
        return Util.ConvertEbcdic(this.data, 180, 8);
    }

    public String mniIdOriginApplid() {
        return Util.ConvertEbcdic(this.data, 188, 8);
    }

    public ZonedDateTime mniIdOriginAttTime() {
        return Util.Binary8xStckTime(this.data, 196);
    }

    public BigInteger mniIdOriginAttTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public long mniIdOriginTrannum() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public String mniIdOriginTranid() {
        return Util.ConvertEbcdic(this.data, 208, 4);
    }

    public String mniIdOriginUserid() {
        return Util.ConvertEbcdic(this.data, 212, 8);
    }

    public String mniIdOriginUserCorr() {
        return Util.ConvertEbcdic(this.data, 220, 64);
    }

    public String mniIdOriginTcpipserv() {
        return Util.ConvertEbcdic(this.data, 284, 8);
    }

    public long mniIdOriginPortnum() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public String mniIdOriginClipaddr() {
        return Util.ConvertEbcdic(this.data, 296, 40);
    }

    public InetAddress mniIdOriginClipaddrAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 296, 40);
    }

    public long mniIdOriginClipport() {
        return Util.ConvertUnsignedBinary4(this.data, 336);
    }

    public long mniIdOriginTranflag() {
        return Util.ConvertUnsignedBinary8(this.data, 340);
    }

    public BigInteger mniIdOriginTranflagAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 340);
    }

    public String mniIdOriginFctyname() {
        return Util.ConvertEbcdic(this.data, 348, 8);
    }

    public String mniPhdNetwkid() {
        return Util.ConvertEbcdic(this.data, 364, 8);
    }

    public String mniPhdApplid() {
        return Util.ConvertEbcdic(this.data, 372, 8);
    }

    public ZonedDateTime mniPhdAttachTime() {
        return Util.Binary8xStckTime(this.data, 380);
    }

    public BigInteger mniPhdAttachTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 380);
    }

    public long mniPhdTrannum() {
        return Util.ConvertUnsignedBinary4(this.data, 388);
    }

    public String mniPhdTranid() {
        return Util.ConvertEbcdic(this.data, 392, 4);
    }

    public long mniPhdCount() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public ZonedDateTime mniPtdAttachTime() {
        return Util.Binary8xStckTime(this.data, 412);
    }

    public BigInteger mniPtdAttachTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 412);
    }

    public long mniPtdTrannum() {
        return Util.ConvertUnsignedBinary4(this.data, 420);
    }

    public String mniPtdTranid() {
        return Util.ConvertEbcdic(this.data, 424, 4);
    }

    public long mniPtdCount() {
        return Util.ConvertUnsignedBinary4(this.data, 428);
    }

    public static MniIdentificationData create(byte[] Data2, int offset, int length) {
        return new MniIdentificationData(Data2, offset, length);
    }

    static enum Field {
        mniIdTranid(0, 4),
        mniIdTermid(4, 4),
        mniIdUserid(8, 8),
        mniIdStype(16, 4),
        mniIdStart(20, 8),
        mniIdStop(28, 8),
        mniIdTaskno(36, 4),
        mniIdLuname(40, 8),
        mniIdPgmname(48, 8),
        mniIdUowPx(56, 20),
        mniIdUowSx(76, 8),
        mniIdRsysid(84, 4),
        mniIdTrnFlags(88, 8),
        mniIdFctyname(96, 4),
        mniIdRtype(100, 4),
        mniIdTerminfo(104, 4),
        mniIdNature(104, 1),
        mniIdSesstype(105, 1),
        mniIdAcmeth(106, 1),
        mniIdDevcode(107, 1),
        mniIdTermcnnm(108, 4),
        mniIdIsipicnm(116, 8),
        mniIdClipaddr(140, 40),
        mniIdOriginNetwkid(180, 8),
        mniIdOriginApplid(188, 8),
        mniIdOriginAttTime(196, 8),
        mniIdOriginTrannum(204, 4),
        mniIdOriginTranid(208, 4),
        mniIdOriginUserid(212, 8),
        mniIdOriginUserCorr(220, 64),
        mniIdOriginTcpipserv(284, 8),
        mniIdOriginPortnum(292, 4),
        mniIdOriginClipaddr(296, 40),
        mniIdOriginClipport(336, 4),
        mniIdOriginTranflag(340, 8),
        mniIdOriginFctyname(348, 8),
        mniPhdNetwkid(364, 8),
        mniPhdApplid(372, 8),
        mniPhdAttachTime(380, 8),
        mniPhdTrannum(388, 4),
        mniPhdTranid(392, 4),
        mniPhdCount(396, 4),
        mniPtdAttachTime(412, 8),
        mniPtdTrannum(420, 4),
        mniPtdTranid(424, 4),
        mniPtdCount(428, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

