/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class MnrWebSvcEntry
extends SmfData {
    private MnrWebSvcEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String mnrWebsvcName() {
        return Util.ConvertEbcdic(this.data, 0, 32);
    }

    public String mnrWebsvcPipe() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public CicsClock mnrWebsvcInvk() {
        return CicsClock.create(this.data, 40, 8);
    }

    @Deprecated
    public Duration mnrWebsvcInvkTime() {
        return Util.Binary4_16_US(this.data, 40);
    }

    @Deprecated
    public double mnrWebsvcInvkTimeSeconds() {
        return Util.ToSeconds(this.mnrWebsvcInvkTime());
    }

    @Deprecated
    public long mnrWebsvcInvkTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    @Deprecated
    public int mnrWebsvcInvkFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    @Deprecated
    public int mnrWebsvcInvkCount() {
        return Util.ConvertUnsignedBinary3(this.data, 45);
    }

    public static MnrWebSvcEntry create(byte[] Data2, int offset, int length) {
        return new MnrWebSvcEntry(Data2, offset, length);
    }

    static enum Field {
        mnrWebsvcName(0, 32),
        mnrWebsvcPipe(32, 8),
        mnrWebsvcInvk(40, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

