/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.W2rAtomservRestype;
import com.blackhillsoftware.smf.cics.statistics.values.W2rAtomservType;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class AtomserviceStatistics
extends StatisticsDataSection {
    public static final int W2RDS_LENGTH = 692;
    public static final int W2RIDR = 110;
    public static final int W2R_VERS = 1;

    private AtomserviceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int w2rdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int w2rdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int w2rdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String w2rAtomservName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public W2rAtomservType w2rAtomservType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 16);
        return W2rAtomservType.from(value);
    }

    public int w2rAtomservTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public String w2rAtomservBindingFile() {
        return Util.ConvertEbcdic(this.data, 20, 255);
    }

    public String w2rAtomservConfigFile() {
        return Util.ConvertEbcdic(this.data, 276, 255);
    }

    public W2rAtomservRestype w2rAtomservRestype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 532);
        return W2rAtomservRestype.from(value);
    }

    public int w2rAtomservRestypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 532);
    }

    public String w2rAtomservResname() {
        return Util.ConvertEbcdic(this.data, 536, 16);
    }

    public long w2rAtomservRefCount() {
        return Util.ConvertUnsignedBinary4(this.data, 560);
    }

    public long w2rAtomservRefDisabled() {
        return Util.ConvertUnsignedBinary4(this.data, 564);
    }

    public long w2rAtomservPostFeedCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 572);
    }

    public long w2rAtomservGetFeedCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 576);
    }

    public long w2rAtomservGetEntryCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 580);
    }

    public long w2rAtomservPutEntryCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 584);
    }

    public long w2rAtomservDelEntryCnt() {
        return Util.ConvertUnsignedBinary4(this.data, 588);
    }

    public String w2rAtomservDefineSource() {
        return Util.ConvertEbcdic(this.data, 608, 8);
    }

    public LocalDateTime w2rAtomservChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 616);
    }

    public BigInteger w2rAtomservChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 616);
    }

    public String w2rAtomservChangeUserid() {
        return Util.ConvertEbcdic(this.data, 624, 8);
    }

    public CIAgent w2rAtomservChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 632);
        return CIAgent.from(value);
    }

    public int w2rAtomservChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 632);
    }

    public CIAgent w2rAtomservInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 634);
        return CIAgent.from(value);
    }

    public int w2rAtomservInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 634);
    }

    public LocalDateTime w2rAtomservInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 636);
    }

    public BigInteger w2rAtomservInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 636);
    }

    public String w2rAtomservInstallUserid() {
        return Util.ConvertEbcdic(this.data, 644, 8);
    }

    public String w2rAtomservUrimap() {
        return Util.ConvertEbcdic(this.data, 652, 8);
    }

    public String w2rAtomservXmltransform() {
        return Util.ConvertEbcdic(this.data, 660, 32);
    }

    public static AtomserviceStatistics create(byte[] Data2, int offset, int length) {
        return new AtomserviceStatistics(Data2, offset, length);
    }

    static enum Field {
        w2rdsLen(0, 2),
        w2rdsId(2, 2),
        w2rdsVers(4, 1),
        w2rAtomservName(8, 8),
        w2rAtomservType(16, 1),
        w2rAtomservBindingFile(20, 255),
        w2rAtomservConfigFile(276, 255),
        w2rAtomservRestype(532, 1),
        w2rAtomservResname(536, 16),
        w2rAtomservRefCount(560, 4),
        w2rAtomservRefDisabled(564, 4),
        w2rAtomservPostFeedCnt(572, 4),
        w2rAtomservGetFeedCnt(576, 4),
        w2rAtomservGetEntryCnt(580, 4),
        w2rAtomservPutEntryCnt(584, 4),
        w2rAtomservDelEntryCnt(588, 4),
        w2rAtomservDefineSource(608, 8),
        w2rAtomservChangeTime(616, 8),
        w2rAtomservChangeUserid(624, 8),
        w2rAtomservChangeAgent(632, 2),
        w2rAtomservInstallAgent(634, 2),
        w2rAtomservInstallTime(636, 8),
        w2rAtomservInstallUserid(644, 8),
        w2rAtomservUrimap(652, 8),
        w2rAtomservXmltransform(660, 32);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

