/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class CfTableStatistics
extends StatisticsDataSection {
    public static final int S7IDE = 127;
    public static final int S7VERS = 1;
    public static final int S7CLEN = 84;

    private CfTableStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int s7len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int s7id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int s7dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String s7table() {
        return Util.ConvertEbcdic(this.data, 8, 16);
    }

    public long s7ocopen() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long s7occlos() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long s7ocset() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long s7ocdele() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long s7ocstat() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long s7rqpoin() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long s7rqhigh() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long s7rqread() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long s7rqrddl() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long s7rqunlk() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long s7rqload() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long s7rqwrit() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long s7rqrewr() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long s7rqdele() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long s7rqdelm() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public static CfTableStatistics create(byte[] Data2, int offset, int length) {
        return new CfTableStatistics(Data2, offset, length);
    }

    static enum Field {
        s7len(0, 2),
        s7id(2, 2),
        s7dvers(4, 1),
        s7table(8, 16),
        s7ocopen(24, 4),
        s7occlos(28, 4),
        s7ocset(32, 4),
        s7ocdele(36, 4),
        s7ocstat(40, 4),
        s7rqpoin(44, 4),
        s7rqhigh(48, 4),
        s7rqread(52, 4),
        s7rqrddl(56, 4),
        s7rqunlk(60, 4),
        s7rqload(64, 4),
        s7rqwrit(68, 4),
        s7rqrewr(72, 4),
        s7rqdele(76, 4),
        s7rqdelm(80, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

