/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.LdpLocation;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class LoaderPrivateProgramStatistics
extends StatisticsDataSection {
    public static final int LDPIDR = 36;
    public static final int LDPVERS = 1;
    public static final int LDPCLEN = 324;

    private LoaderPrivateProgramStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ldplen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ldpid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ldpdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ldpPlatformName() {
        return Util.ConvertEbcdic(this.data, 8, 64);
    }

    public String ldpApplicationName() {
        return Util.ConvertEbcdic(this.data, 72, 64);
    }

    public long ldpApplMajorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long ldpApplMinorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long ldpApplMicroVer() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public String ldppname() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public long ldptu() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long ldpfc() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public Duration ldpft() {
        return Util.Binary4_16_US(this.data, 164);
    }

    public double ldpftSeconds() {
        return Util.ToSeconds(this.ldpft());
    }

    public double ldpftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long ldprplo() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long ldptn() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public long ldppsize() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long ldprpc() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public LdpLocation ldplocn() {
        int value = Util.ConvertUnsignedBinary1(this.data, 184);
        return LdpLocation.from(value);
    }

    public int ldplocnRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 184);
    }

    public String ldplbnm() {
        return Util.ConvertEbcdic(this.data, 188, 8);
    }

    public String ldplbdnm() {
        return Util.ConvertEbcdic(this.data, 196, 44);
    }

    public String ldpOperationName() {
        return Util.ConvertEbcdic(this.data, 240, 64);
    }

    public static LoaderPrivateProgramStatistics create(byte[] Data2, int offset, int length) {
        return new LoaderPrivateProgramStatistics(Data2, offset, length);
    }

    static enum Field {
        ldplen(0, 2),
        ldpid(2, 2),
        ldpdvers(4, 1),
        ldpPlatformName(8, 64),
        ldpApplicationName(72, 64),
        ldpApplMajorVer(136, 4),
        ldpApplMinorVer(140, 4),
        ldpApplMicroVer(144, 4),
        ldppname(148, 8),
        ldptu(156, 4),
        ldpfc(160, 4),
        ldpft(164, 4),
        ldprplo(168, 4),
        ldptn(172, 4),
        ldppsize(176, 4),
        ldprpc(180, 4),
        ldplocn(184, 1),
        ldplbnm(188, 8),
        ldplbdnm(196, 44),
        ldpOperationName(240, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

