/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.LgrJtype;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class LogManagerJournalStatistics
extends StatisticsDataSection {
    public static final int LGRDSLEN = 68;
    public static final int LGRIDR = 93;
    public static final int LGRVERS = 1;

    private LogManagerJournalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int lgrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int lgrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int lgrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String lgrjnlname() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public LgrJtype lgrjtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 16);
        return LgrJtype.from(value);
    }

    public int lgrjtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public String lgrstream() {
        return Util.ConvertEbcdic(this.data, 18, 26);
    }

    public long lgrwrites() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long lgrbytes() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger lgrbytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long lgrbuflsh() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public static LogManagerJournalStatistics create(byte[] Data2, int offset, int length) {
        return new LogManagerJournalStatistics(Data2, offset, length);
    }

    static enum Field {
        lgrlen(0, 2),
        lgrid(2, 2),
        lgrdvers(4, 1),
        lgrjnlname(8, 8),
        lgrjtype(16, 1),
        lgrstream(18, 26),
        lgrwrites(44, 4),
        lgrbytes(48, 8),
        lgrbuflsh(56, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

