/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.SjnNodejsappState;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;

public final class NodeJsAppStatistics
extends StatisticsDataSection {
    public static final int SJNIDR = 150;
    public static final int SJN_VERS = 1;

    private NodeJsAppStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int sjndsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sjndsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sjndsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String sjnNodejsappName() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public String sjnNodejsappLeRunopts() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public SjnNodejsappState sjnNodejsappState() {
        int value = Util.ConvertUnsignedBinary1(this.data, 48);
        return SjnNodejsappState.from(value);
    }

    public int sjnNodejsappStateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 48);
    }

    public String sjnNodejsappDefineSource() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    public LocalDateTime sjnNodejsappChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 60);
    }

    public BigInteger sjnNodejsappChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 60);
    }

    public String sjnNodejsappChangeUserid() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public CIAgent sjnNodejsappChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 76);
        return CIAgent.from(value);
    }

    public int sjnNodejsappChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public CIAgent sjnNodejsappInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 78);
        return CIAgent.from(value);
    }

    public int sjnNodejsappInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 78);
    }

    public LocalDateTime sjnNodejsappInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 80);
    }

    public BigInteger sjnNodejsappInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String sjnNodejsappInstallUserid() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public LocalDateTime sjnNodejsappCreationLcl() {
        return Util.Binary8xStckLocalTime(this.data, 96);
    }

    public BigInteger sjnNodejsappCreationLclRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long sjnNodejsappPid() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public String sjnNodejsappBundleName() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public Duration sjnNodejsappCpu() {
        return Util.Binary8StckInterval(this.data, 120);
    }

    public double sjnNodejsappCpuSeconds() {
        return Util.ToSeconds(this.sjnNodejsappCpu());
    }

    public long sjnNodejsappCpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 120);
    }

    public long sjnNodejsappHeapCurrent() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger sjnNodejsappHeapCurrentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long sjnNodejsappHeapRuntime() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger sjnNodejsappHeapRuntimeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long sjnNodejsappHeapAppData() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger sjnNodejsappHeapAppDataAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public long sjnNodejsappHeapMax() {
        return Util.ConvertUnsignedBinary8(this.data, 152);
    }

    public BigInteger sjnNodejsappHeapMaxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 152);
    }

    public long sjnNodejsappInvk() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long sjnNodejsappInvkErr() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long sjnNodejsappInvkCur() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long sjnNodejsappInvkPeak() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public String sjnNodejsappNodehome() {
        return Util.ConvertEbcdic(this.data, 176, 255);
    }

    public String sjnNodejsappProfile() {
        return Util.ConvertEbcdic(this.data, 431, 255);
    }

    public String sjnNodejsappStartscrit() {
        return Util.ConvertEbcdic(this.data, 686, 255);
    }

    public String sjnNodejsappStderr() {
        return Util.ConvertEbcdic(this.data, 941, 255);
    }

    public String sjnNodejsappStdout() {
        return Util.ConvertEbcdic(this.data, 1196, 255);
    }

    public String sjnNodejsappTrace() {
        return Util.ConvertEbcdic(this.data, 1451, 255);
    }

    public String sjnNodejsappLog() {
        return Util.ConvertEbcdic(this.data, 1706, 255);
    }

    public static NodeJsAppStatistics create(byte[] Data2, int offset, int length) {
        return new NodeJsAppStatistics(Data2, offset, length);
    }

    static enum Field {
        sjndsLen(0, 2),
        sjndsId(2, 2),
        sjndsVers(4, 1),
        sjnNodejsappName(8, 32),
        sjnNodejsappLeRunopts(40, 8),
        sjnNodejsappState(48, 1),
        sjnNodejsappDefineSource(52, 8),
        sjnNodejsappChangeTime(60, 8),
        sjnNodejsappChangeUserid(68, 8),
        sjnNodejsappChangeAgent(76, 2),
        sjnNodejsappInstallAgent(78, 2),
        sjnNodejsappInstallTime(80, 8),
        sjnNodejsappInstallUserid(88, 8),
        sjnNodejsappCreationLcl(96, 8),
        sjnNodejsappPid(104, 4),
        sjnNodejsappBundleName(108, 8),
        sjnNodejsappCpu(120, 8),
        sjnNodejsappHeapCurrent(128, 8),
        sjnNodejsappHeapRuntime(136, 8),
        sjnNodejsappHeapAppData(144, 8),
        sjnNodejsappHeapMax(152, 8),
        sjnNodejsappInvk(160, 4),
        sjnNodejsappInvkErr(164, 4),
        sjnNodejsappInvkCur(168, 4),
        sjnNodejsappInvkPeak(172, 4),
        sjnNodejsappNodehome(176, 255),
        sjnNodejsappProfile(431, 255),
        sjnNodejsappStartscrit(686, 255),
        sjnNodejsappStderr(941, 255),
        sjnNodejsappStdout(1196, 255),
        sjnNodejsappTrace(1451, 255),
        sjnNodejsappLog(1706, 255);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

