/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.PirPipelineJavaParser;
import com.blackhillsoftware.smf.cics.statistics.values.PirPipelineMode;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class PipelineStatistics
extends StatisticsDataSection {
    public static final int PIRDS_LENGTH = 1156;
    public static final int PIRIDR = 105;
    public static final int PIR_VERS = 1;

    private PipelineStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int pirdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int pirdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int pirdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String pirPipelineName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public PirPipelineMode pirPipelineMode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 16);
        return PirPipelineMode.from(value);
    }

    public int pirPipelineModeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public String pirConfigurationFile() {
        return Util.ConvertEbcdic(this.data, 32, 255);
    }

    public String pirShelfDirectory() {
        return Util.ConvertEbcdic(this.data, 288, 255);
    }

    public String pirWsdirDirectory() {
        return Util.ConvertEbcdic(this.data, 544, 255);
    }

    public long pirPipelineUseCount() {
        return Util.ConvertUnsignedBinary4(this.data, 800);
    }

    public PirPipelineJavaParser pirJsonJavaParser() {
        int value = Util.ConvertUnsignedBinary1(this.data, 804);
        return PirPipelineJavaParser.from(value);
    }

    public int pirJsonJavaParserRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 804);
    }

    public String pirPipelineDefineSource() {
        return Util.ConvertEbcdic(this.data, 1104, 8);
    }

    public LocalDateTime pirPipelineChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 1112);
    }

    public BigInteger pirPipelineChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1112);
    }

    public String pirPipelineChangeUserid() {
        return Util.ConvertEbcdic(this.data, 1120, 8);
    }

    public CIAgent pirPipelineChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1128);
        return CIAgent.from(value);
    }

    public int pirPipelineChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1128);
    }

    public CIAgent pirPipelineInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1130);
        return CIAgent.from(value);
    }

    public int pirPipelineInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1130);
    }

    public LocalDateTime pirPipelineInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 1132);
    }

    public BigInteger pirPipelineInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1132);
    }

    public String pirPipelineInstallUserid() {
        return Util.ConvertEbcdic(this.data, 1140, 8);
    }

    public String pirPipelineMsgformat() {
        return Util.ConvertEbcdic(this.data, 1148, 8);
    }

    public static PipelineStatistics create(byte[] Data2, int offset, int length) {
        return new PipelineStatistics(Data2, offset, length);
    }

    static enum Field {
        pirdsLen(0, 2),
        pirdsId(2, 2),
        pirdsVers(4, 1),
        pirPipelineName(8, 8),
        pirPipelineMode(16, 1),
        pirConfigurationFile(32, 255),
        pirShelfDirectory(288, 255),
        pirWsdirDirectory(544, 255),
        pirPipelineUseCount(800, 4),
        pirJsonJavaParser(804, 1),
        pirPipelineDefineSource(1104, 8),
        pirPipelineChangeTime(1112, 8),
        pirPipelineChangeUserid(1120, 8),
        pirPipelineChangeAgent(1128, 2),
        pirPipelineInstallAgent(1130, 2),
        pirPipelineInstallTime(1132, 8),
        pirPipelineInstallUserid(1140, 8),
        pirPipelineMsgformat(1148, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

