/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class PolicyStatistics
extends StatisticsDataSection {
    public static final int MPRIDR = 145;
    public static final int MPRVERS = 1;

    private PolicyStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mprlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mprid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mprdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String mprPolicyName() {
        return Util.ConvertEbcdic(this.data, 8, 64);
    }

    public String mprRuleName() {
        return Util.ConvertEbcdic(this.data, 72, 64);
    }

    public String mprPolicyUsertag() {
        return Util.ConvertEbcdic(this.data, 136, 8);
    }

    public String mprBundleName() {
        return Util.ConvertEbcdic(this.data, 144, 8);
    }

    public String mprBundleDir() {
        return Util.ConvertEbcdic(this.data, 152, 255);
    }

    public String mprRuleType() {
        return Util.ConvertEbcdic(this.data, 408, 16);
    }

    public String mprRuleSubtype() {
        return Util.ConvertEbcdic(this.data, 424, 16);
    }

    public String mprActionType() {
        return Util.ConvertEbcdic(this.data, 456, 16);
    }

    public long mprActionCount() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public LocalDateTime mprActionTime() {
        return Util.Binary8xStckLocalTime(this.data, 492);
    }

    public BigInteger mprActionTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 492);
    }

    public static PolicyStatistics create(byte[] Data2, int offset, int length) {
        return new PolicyStatistics(Data2, offset, length);
    }

    static enum Field {
        mprlen(0, 2),
        mprid(2, 2),
        mprdvers(4, 1),
        mprPolicyName(8, 64),
        mprRuleName(72, 64),
        mprPolicyUsertag(136, 8),
        mprBundleName(144, 8),
        mprBundleDir(152, 255),
        mprRuleType(408, 16),
        mprRuleSubtype(424, 16),
        mprActionType(456, 16),
        mprActionCount(488, 4),
        mprActionTime(492, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

