/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.ExecKey;
import com.blackhillsoftware.smf.internal.Util;

public final class PrivateJvmProgramStatistics
extends StatisticsDataSection {
    public static final int PGPDS_LENGTH = 516;
    public static final int PGP_IDR = 146;
    public static final int PGP_VERS = 1;
    public static final int PGP_ENTRYPOINT_NO = 1;
    public static final int PGP_ENTRYPOINT_YES = 2;

    private PrivateJvmProgramStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int pgpdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int pgpdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int pgpdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String pgpJvmprogramPlatformName() {
        return Util.ConvertEbcdic(this.data, 8, 64);
    }

    public String pgpJvmprogramApplicationName() {
        return Util.ConvertEbcdic(this.data, 72, 64);
    }

    public long pgpJvmprogramApplMajorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long pgpJvmprogramApplMinorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long pgpJvmprogramApplMicroVer() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public String pgpJvmprogramName() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public int pgpJvmprogramEntrypoint() {
        return Util.ConvertUnsignedBinary1(this.data, 163);
    }

    public long pgpJvmprogramUsecount() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public ExecKey pgpJvmprogramExecKey() {
        int value = Util.ConvertUnsignedBinary1(this.data, 168);
        return ExecKey.from(value);
    }

    public int pgpJvmprogramExecKeyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 168);
    }

    public String pgpJvmprogramJvmclass() {
        return Util.ConvertEbcdic(this.data, 172, 255);
    }

    public String pgpJvmprogramServer() {
        return Util.ConvertEbcdic(this.data, 428, 8);
    }

    public String pgpJvmprogramOperationName() {
        return Util.ConvertEbcdic(this.data, 436, 64);
    }

    public boolean pgpEntrypointYes() {
        return Util.ConvertEquateValue(this.data, this.pgpJvmprogramEntrypoint(), 2);
    }

    public static PrivateJvmProgramStatistics create(byte[] Data2, int offset, int length) {
        return new PrivateJvmProgramStatistics(Data2, offset, length);
    }

    static enum Field {
        pgpdsLen(0, 2),
        pgpdsId(2, 2),
        pgpdsVers(4, 1),
        pgpJvmprogramPlatformName(8, 64),
        pgpJvmprogramApplicationName(72, 64),
        pgpJvmprogramApplMajorVer(136, 4),
        pgpJvmprogramApplMinorVer(140, 4),
        pgpJvmprogramApplMicroVer(144, 4),
        pgpJvmprogramName(148, 8),
        pgpJvmprogramEntrypoint(163, 1),
        pgpJvmprogramUsecount(164, 4),
        pgpJvmprogramExecKey(168, 1),
        pgpJvmprogramJvmclass(172, 255),
        pgpJvmprogramServer(428, 8),
        pgpJvmprogramOperationName(436, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

