/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.DataLoc;
import com.blackhillsoftware.smf.cics.statistics.values.ExecKey;
import com.blackhillsoftware.smf.cics.statistics.values.PgeProgramApi;
import com.blackhillsoftware.smf.cics.statistics.values.PgeProgramConcurrency;
import com.blackhillsoftware.smf.cics.statistics.values.PgeProgramExecutionSet;
import com.blackhillsoftware.smf.cics.statistics.values.PgeProgramRuntimeEnv;
import com.blackhillsoftware.smf.cics.statistics.values.PgeProgramType;
import com.blackhillsoftware.smf.cics.statistics.values.ProgramLanguage;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class PrivateProgramdefStatistics
extends StatisticsDataSection {
    public static final int PGEDS_LENGTH = 340;
    public static final int PGE_IDR = 147;
    public static final int PGE_VERS = 1;
    public static final int PGE_REMOTE_NO = 1;
    public static final int PGE_REMOTE_YES = 2;
    public static final int PGE_DYNAMIC_NO = 1;
    public static final int PGE_DYNAMIC_YES = 2;
    public static final int PGE_JVM_NO = 1;
    public static final int PGE_JVM_YES = 2;

    private PrivateProgramdefStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int pgedsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int pgedsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int pgedsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String pgeProgramPlatformName() {
        return Util.ConvertEbcdic(this.data, 8, 64);
    }

    public String pgeProgramApplicationName() {
        return Util.ConvertEbcdic(this.data, 72, 64);
    }

    public long pgeProgramApplMajorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long pgeProgramApplMinorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long pgeProgramApplMicroVer() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public String pgeProgramName() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public PgeProgramType pgeProgramType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 156);
        return PgeProgramType.from(value);
    }

    public int pgeProgramTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 156);
    }

    public ExecKey pgeProgramExecKey() {
        int value = Util.ConvertUnsignedBinary1(this.data, 157);
        return ExecKey.from(value);
    }

    public int pgeProgramExecKeyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 157);
    }

    public DataLoc pgeProgramDataLoc() {
        int value = Util.ConvertUnsignedBinary1(this.data, 158);
        return DataLoc.from(value);
    }

    public int pgeProgramDataLocRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 158);
    }

    public PgeProgramExecutionSet pgeProgramExecutionSet() {
        int value = Util.ConvertUnsignedBinary1(this.data, 159);
        return PgeProgramExecutionSet.from(value);
    }

    public int pgeProgramExecutionSetRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 159);
    }

    public ProgramLanguage pgeProgramLangDeduced() {
        int value = Util.ConvertUnsignedBinary1(this.data, 164);
        return ProgramLanguage.deduced(value);
    }

    public int pgeProgramLangDeducedRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 164);
    }

    public ProgramLanguage pgeProgramLanguage() {
        int value = Util.ConvertUnsignedBinary1(this.data, 165);
        return ProgramLanguage.value(value);
    }

    public int pgeProgramLanguageRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 165);
    }

    public PgeProgramRuntimeEnv pgeProgramRuntimeEnv() {
        int value = Util.ConvertUnsignedBinary1(this.data, 166);
        return PgeProgramRuntimeEnv.from(value);
    }

    public int pgeProgramRuntimeEnvRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 166);
    }

    public PgeProgramConcurrency pgeProgramConcurrency() {
        int value = Util.ConvertUnsignedBinary1(this.data, 172);
        return PgeProgramConcurrency.from(value);
    }

    public int pgeProgramConcurrencyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 172);
    }

    public PgeProgramApi pgeProgramApi() {
        int value = Util.ConvertUnsignedBinary1(this.data, 173);
        return PgeProgramApi.from(value);
    }

    public int pgeProgramApiRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 173);
    }

    public int pgeProgramRemote() {
        return Util.ConvertUnsignedBinary1(this.data, 177);
    }

    public int pgeProgramDynamic() {
        return Util.ConvertUnsignedBinary1(this.data, 178);
    }

    public int pgeProgramJvm() {
        return Util.ConvertUnsignedBinary1(this.data, 179);
    }

    public int pgeProgramEntrypoint() {
        return Util.ConvertUnsignedBinary1(this.data, 180);
    }

    public String pgeProgramRemoteName() {
        return Util.ConvertEbcdic(this.data, 184, 8);
    }

    public String pgeProgramTranId() {
        return Util.ConvertEbcdic(this.data, 192, 4);
    }

    public String pgeProgramRemoteSysid() {
        return Util.ConvertEbcdic(this.data, 196, 4);
    }

    public String pgeProgramJvmserver() {
        return Util.ConvertEbcdic(this.data, 212, 8);
    }

    public String pgeProgramDefineSource() {
        return Util.ConvertEbcdic(this.data, 228, 8);
    }

    public LocalDateTime pgeProgramChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 236);
    }

    public BigInteger pgeProgramChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 236);
    }

    public String pgeProgramChangeUserid() {
        return Util.ConvertEbcdic(this.data, 244, 8);
    }

    public CIAgent pgeProgramChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 252);
        return CIAgent.from(value);
    }

    public int pgeProgramChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 252);
    }

    public CIAgent pgeProgramInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 254);
        return CIAgent.from(value);
    }

    public int pgeProgramInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 254);
    }

    public LocalDateTime pgeProgramInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 256);
    }

    public BigInteger pgeProgramInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 256);
    }

    public String pgeProgramInstallUserid() {
        return Util.ConvertEbcdic(this.data, 264, 8);
    }

    public String pgeProgramOperationName() {
        return Util.ConvertEbcdic(this.data, 272, 64);
    }

    public boolean pgeRemoteYes() {
        return Util.ConvertEquateValue(this.data, this.pgeProgramRemote(), 2);
    }

    public boolean pgeDynamicYes() {
        return Util.ConvertEquateValue(this.data, this.pgeProgramDynamic(), 2);
    }

    public boolean pgeJvmYes() {
        return Util.ConvertEquateValue(this.data, this.pgeProgramJvm(), 2);
    }

    public static PrivateProgramdefStatistics create(byte[] Data2, int offset, int length) {
        return new PrivateProgramdefStatistics(Data2, offset, length);
    }

    static enum Field {
        pgedsLen(0, 2),
        pgedsId(2, 2),
        pgedsVers(4, 1),
        pgeProgramPlatformName(8, 64),
        pgeProgramApplicationName(72, 64),
        pgeProgramApplMajorVer(136, 4),
        pgeProgramApplMinorVer(140, 4),
        pgeProgramApplMicroVer(144, 4),
        pgeProgramName(148, 8),
        pgeProgramType(156, 1),
        pgeProgramExecKey(157, 1),
        pgeProgramDataLoc(158, 1),
        pgeProgramExecutionSet(159, 1),
        pgeProgramLangDeduced(164, 1),
        pgeProgramLanguage(165, 1),
        pgeProgramRuntimeEnv(166, 1),
        pgeProgramConcurrency(172, 1),
        pgeProgramApi(173, 1),
        pgeProgramRemote(177, 1),
        pgeProgramDynamic(178, 1),
        pgeProgramJvm(179, 1),
        pgeProgramEntrypoint(180, 1),
        pgeProgramRemoteName(184, 8),
        pgeProgramTranId(192, 4),
        pgeProgramRemoteSysid(196, 4),
        pgeProgramJvmserver(212, 8),
        pgeProgramDefineSource(228, 8),
        pgeProgramChangeTime(236, 8),
        pgeProgramChangeUserid(244, 8),
        pgeProgramChangeAgent(252, 2),
        pgeProgramInstallAgent(254, 2),
        pgeProgramInstallTime(256, 8),
        pgeProgramInstallUserid(264, 8),
        pgeProgramOperationName(272, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

