/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.SogSotuning;
import com.blackhillsoftware.smf.cics.statistics.values.SogSslCache;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;

public final class SocketsGlobalStatistics
extends StatisticsDataSection {
    public static final int SOGIDR = 107;
    public static final int SOG_STOPPING_PERSISTENCE_ON = 1;
    public static final int SOG_STOPPING_PERSISTENCE_OFF = 2;
    public static final int SOG_PAUSING_LISTENING_ON = 1;
    public static final int SOG_PAUSING_LISTENING_OFF = 2;

    private SocketsGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int sogdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sogdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sogdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long sogMaxsocketsLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long sogCurrInboundSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long sogPeakInboundSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long sogCurrOutbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long sogPeakOutbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    @Deprecated
    public long sogCurrPersOutbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    @Deprecated
    public long sogPeakPersOutbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long sogInbSocketsCreated() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long sogOutbSocketsCreated() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long sogOutbSocketsClosed() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long sogTimesAtMaxSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long sogDelayedAtMaxSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration sogQtimeAtMaxSockets() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    public double sogQtimeAtMaxSocketsSeconds() {
        return Util.ToSeconds(this.sogQtimeAtMaxSockets());
    }

    public long sogQtimeAtMaxSocketsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    public long sogTimedoutAtMaxSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long sogCurrDelayedAtMax() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long sogPeakDelayedAtMax() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public Duration sogCurrentQtimeAtMax() {
        return Util.Binary8StckInterval(this.data, 76);
    }

    public double sogCurrentQtimeAtMaxSeconds() {
        return Util.ToSeconds(this.sogCurrentQtimeAtMax());
    }

    public long sogCurrentQtimeAtMaxRawValue() {
        return Util.ConvertSignedBinary8(this.data, 76);
    }

    public SogSslCache sogSslcache() {
        int value = Util.ConvertUnsignedBinary1(this.data, 92);
        return SogSslCache.from(value);
    }

    public int sogSslcacheRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 92);
    }

    public SogSotuning sogSotuning() {
        int value = Util.ConvertUnsignedBinary1(this.data, 93);
        return SogSotuning.from(value);
    }

    public int sogSotuningRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 93);
    }

    public int sogPausingHttpListening() {
        return Util.ConvertUnsignedBinary1(this.data, 94);
    }

    public int sogStoppingPersistence() {
        return Util.ConvertUnsignedBinary1(this.data, 95);
    }

    public long sogTimesAtAcceptLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public LocalDateTime sogTimeLastPausedHttpListening() {
        return Util.Binary8xStckLocalTime(this.data, 104);
    }

    public BigInteger sogTimeLastPausedHttpListeningRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long sogTimesStoppedPersistent() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public LocalDateTime sogTimeLastStoppedPersistent() {
        return Util.Binary8xStckLocalTime(this.data, 116);
    }

    public BigInteger sogTimeLastStoppedPersistentRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 116);
    }

    public long sogTimesMadeNonPersistent() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long sogTimesConnDisconnectedAtMax() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    @Deprecated
    public long sogPersOutboundCreated() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    @Deprecated
    public long sogPeakBothOutbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long sogPeakPersInbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long sogPeakNpersInbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public long sogCurrNpersInbSockets() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public long sogNpersInbSocketsCreated() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long sogTimesOutbReused() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long sogS8tlshsRequestsMax() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long sogS8tlshsRequestsCur() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long sogS8tlshsRequestsPeak() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long sogS8tlshsWaitersMax() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public long sogS8tlshsWaitersCur() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long sogS8tlshsWaitersPeak() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long sogTimesCicstls11InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long sogTimesCicstls12InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long sogTimesCicstls13InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long sogTimesCicstlsallInbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long sogTimesCicstls11OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long sogTimesCicstls12OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long sogTimesCicstls13OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public long sogTimesCicstlsallOutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long sogTimesAtssl3InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public long sogTimesAttls10InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 220);
    }

    public long sogTimesAttls11InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 224);
    }

    public long sogTimesAttls12InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 228);
    }

    public long sogTimesAttls13InbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public long sogTimesAtssl3OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public long sogTimesAttls10OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public long sogTimesAttls11OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 244);
    }

    public long sogTimesAttls12OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 248);
    }

    public long sogTimesAttls13OutbUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 252);
    }

    public long sogHandshakesFullInb() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long sogHandshakesAbbrevInb() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long sogHandshakesFullOutb() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long sogHandshakesAbbrevOutb() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public boolean sogStoppingPersistenceOn() {
        return Util.ConvertEquateValue(this.data, this.sogStoppingPersistence(), 1);
    }

    public boolean sogPausingListeningOn() {
        return Util.ConvertEquateValue(this.data, this.sogPausingHttpListening(), 1);
    }

    public static SocketsGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new SocketsGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        sogdsLen(0, 2),
        sogdsId(2, 2),
        sogdsVers(4, 1),
        sogMaxsocketsLimit(8, 4),
        sogCurrInboundSockets(12, 4),
        sogPeakInboundSockets(16, 4),
        sogCurrOutbSockets(20, 4),
        sogPeakOutbSockets(24, 4),
        sogCurrPersOutbSockets(28, 4),
        sogPeakPersOutbSockets(32, 4),
        sogInbSocketsCreated(36, 4),
        sogOutbSocketsCreated(40, 4),
        sogOutbSocketsClosed(44, 4),
        sogTimesAtMaxSockets(48, 4),
        sogDelayedAtMaxSockets(52, 4),
        sogQtimeAtMaxSockets(56, 8),
        sogTimedoutAtMaxSockets(64, 4),
        sogCurrDelayedAtMax(68, 4),
        sogPeakDelayedAtMax(72, 4),
        sogCurrentQtimeAtMax(76, 8),
        sogSslcache(92, 1),
        sogSotuning(93, 1),
        sogPausingHttpListening(94, 1),
        sogStoppingPersistence(95, 1),
        sogTimesAtAcceptLimit(100, 4),
        sogTimeLastPausedHttpListening(104, 8),
        sogTimesStoppedPersistent(112, 4),
        sogTimeLastStoppedPersistent(116, 8),
        sogTimesMadeNonPersistent(124, 4),
        sogTimesConnDisconnectedAtMax(128, 4),
        sogPersOutboundCreated(132, 4),
        sogPeakBothOutbSockets(136, 4),
        sogPeakPersInbSockets(140, 4),
        sogPeakNpersInbSockets(144, 4),
        sogCurrNpersInbSockets(148, 4),
        sogNpersInbSocketsCreated(152, 4),
        sogTimesOutbReused(156, 4),
        sogS8tlshsRequestsMax(160, 4),
        sogS8tlshsRequestsCur(164, 4),
        sogS8tlshsRequestsPeak(168, 4),
        sogS8tlshsWaitersMax(172, 4),
        sogS8tlshsWaitersCur(176, 4),
        sogS8tlshsWaitersPeak(180, 4),
        sogTimesCicstls11InbUsed(184, 4),
        sogTimesCicstls12InbUsed(188, 4),
        sogTimesCicstls13InbUsed(192, 4),
        sogTimesCicstlsallInbUsed(196, 4),
        sogTimesCicstls11OutbUsed(200, 4),
        sogTimesCicstls12OutbUsed(204, 4),
        sogTimesCicstls13OutbUsed(208, 4),
        sogTimesCicstlsallOutbUsed(212, 4),
        sogTimesAtssl3InbUsed(216, 4),
        sogTimesAttls10InbUsed(220, 4),
        sogTimesAttls11InbUsed(224, 4),
        sogTimesAttls12InbUsed(228, 4),
        sogTimesAttls13InbUsed(232, 4),
        sogTimesAtssl3OutbUsed(236, 4),
        sogTimesAttls10OutbUsed(240, 4),
        sogTimesAttls11OutbUsed(244, 4),
        sogTimesAttls12OutbUsed(248, 4),
        sogTimesAttls13OutbUsed(252, 4),
        sogHandshakesFullInb(256, 4),
        sogHandshakesAbbrevInb(260, 4),
        sogHandshakesFullOutb(264, 4),
        sogHandshakesAbbrevOutb(268, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

