/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class StatisticsStatistics
extends StatisticsDataSection {
    public static final int STGIDE = 66;
    public static final int STGVERS = 1;
    public static final int STGCLEN = 88;

    private StatisticsStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int stglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int stgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int stgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long stgnc() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long stgsmfw() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long stgldw() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long stgsmfs() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long stgsmfe() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long stgintr() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long stgeodr() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long stgussr() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long stgreqr() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long stgrrtr() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public ZonedDateTime stgcstrt() {
        return Util.Binary8xStckTime(this.data, 56);
    }

    public BigInteger stgcstrtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public ZonedDateTime stglrt() {
        return Util.Binary8xStckTime(this.data, 64);
    }

    public BigInteger stglrtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public Duration stgintvl() {
        return Util.Binary8StckInterval(this.data, 72);
    }

    public double stgintvlSeconds() {
        return Util.ToSeconds(this.stgintvl());
    }

    public long stgintvlRawValue() {
        return Util.ConvertSignedBinary8(this.data, 72);
    }

    public LocalTime stgeodt() {
        return Util.EBCDIC6hhmmss(this.data, 80);
    }

    public String stgeodtRawValue() {
        return Util.ConvertEbcdic(this.data, 80, 6);
    }

    public int stgstrcd() {
        return Util.ConvertUnsignedBinary1(this.data, 86);
    }

    public static StatisticsStatistics create(byte[] Data2, int offset, int length) {
        return new StatisticsStatistics(Data2, offset, length);
    }

    static enum Field {
        stglen(0, 2),
        stgid(2, 2),
        stgdvers(4, 1),
        stgnc(8, 4),
        stgsmfw(12, 4),
        stgldw(16, 4),
        stgsmfs(24, 4),
        stgsmfe(28, 4),
        stgintr(32, 4),
        stgeodr(36, 4),
        stgussr(40, 4),
        stgreqr(44, 4),
        stgrrtr(48, 4),
        stgcstrt(56, 8),
        stglrt(64, 8),
        stgintvl(72, 8),
        stgeodt(80, 6),
        stgstrcd(86, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

