/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.statistics.values.Location;
import com.blackhillsoftware.smf.cics.statistics.values.SmsAccess;
import com.blackhillsoftware.smf.cics.statistics.values.SmsDsaIndexes;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class StorageManagerDsaStatistics
extends SmfData {
    public static final int SMSBLEN = 128;

    private StorageManagerDsaStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smsdsaname() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public Location smslocn() {
        int value = Util.ConvertUnsignedBinary1(this.data, 8);
        return Location.from(value);
    }

    public int smslocnRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public SmsAccess smsaccess() {
        int value = Util.ConvertUnsignedBinary1(this.data, 9);
        return SmsAccess.from(value);
    }

    public int smsaccessRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public SmsDsaIndexes smsdsaindex() {
        int value = Util.ConvertUnsignedBinary1(this.data, 10);
        return SmsDsaIndexes.from(value);
    }

    public int smsdsaindexRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 10);
    }

    public long smsdsasz() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smshwmdsasz() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smscsize() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smsgmreq() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smsfmreq() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smsasr() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smsdsr() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smscriss() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smsucss() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smscss() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smshwmss() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smspwws() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smscrel() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smssos() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public Duration smstsos() {
        return Util.Binary8StckInterval(this.data, 72);
    }

    public double smstsosSeconds() {
        return Util.ToSeconds(this.smstsos());
    }

    public long smstsosRawValue() {
        return Util.ConvertSignedBinary8(this.data, 72);
    }

    public long smscsubp() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smsfstg() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smshwmfstg() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smslwmfstg() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smslfa() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smssv() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long smsexts() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long smsextsa() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long smsextsr() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public static StorageManagerDsaStatistics create(byte[] Data2, int offset, int length) {
        return new StorageManagerDsaStatistics(Data2, offset, length);
    }

    static enum Field {
        smsdsaname(0, 8),
        smslocn(8, 1),
        smsaccess(9, 1),
        smsdsaindex(10, 1),
        smsdsasz(12, 4),
        smshwmdsasz(16, 4),
        smscsize(20, 4),
        smsgmreq(24, 4),
        smsfmreq(28, 4),
        smsasr(32, 4),
        smsdsr(36, 4),
        smscriss(40, 4),
        smsucss(44, 4),
        smscss(48, 4),
        smshwmss(52, 4),
        smspwws(56, 4),
        smscrel(60, 4),
        smssos(64, 4),
        smstsos(72, 8),
        smscsubp(80, 4),
        smsfstg(84, 4),
        smshwmfstg(88, 4),
        smslwmfstg(92, 4),
        smslfa(96, 4),
        smssv(100, 4),
        smsexts(104, 4),
        smsextsa(108, 4),
        smsextsr(112, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

