/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.StorageManagerDsaStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageManagerGlobalStatistics;
import com.blackhillsoftware.smf.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class StorageManagerStatistics
extends StatisticsDataSection {
    public static final int SMSIDE = 29;
    public static final int SMSVERS = 1;
    private StorageManagerGlobalStatistics storageManagerGlobalStatistics = null;
    public static final int SMSHLEN = 8;

    private StorageManagerStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smslen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smsid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smsdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public StorageManagerGlobalStatistics storageManagerGlobalStatistics() {
        if (this.storageManagerGlobalStatistics == null) {
            int offset = 8;
            int length = StorageManagerGlobalStatistics.smsgbllen(this.data, offset);
            this.storageManagerGlobalStatistics = StorageManagerGlobalStatistics.create(this.data, offset, length);
        }
        return this.storageManagerGlobalStatistics;
    }

    public List<StorageManagerDsaStatistics> storageManagerDsaStatistics() {
        int datastart = this.storageManagerGlobalStatistics().smsgbllen();
        int count = this.storageManagerGlobalStatistics().smsnpagp();
        int length = (this.smslen() - datastart) / count;
        ArrayList<StorageManagerDsaStatistics> result = new ArrayList<StorageManagerDsaStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(StorageManagerDsaStatistics.create(this.data, datastart + i * length, length));
        }
        return Collections.unmodifiableList(result);
    }

    public static StorageManagerStatistics create(byte[] Data2, int offset, int length) {
        return new StorageManagerStatistics(Data2, offset, length);
    }

    static enum Field {
        smslen(0, 2),
        smsid(2, 2),
        smsdvers(4, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

