/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.StorageTaskSubpoolStatisticsEntry;
import com.blackhillsoftware.smf.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class StorageTaskSubpoolStatistics
extends StatisticsDataSection {
    public static final int SMTIDE = 20;
    public static final int SMTVERS = 1;
    public static final int SMTHLEN = 8;
    public static final int SMTGLEN = 4;

    private StorageTaskSubpoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smtlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smtid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smtdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smtntask() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public List<StorageTaskSubpoolStatisticsEntry> storageTaskSubpoolStatisticsEntries() {
        int datastart = 12;
        int count = this.smtntask();
        ArrayList<StorageTaskSubpoolStatisticsEntry> result = new ArrayList<StorageTaskSubpoolStatisticsEntry>(count);
        for (int i = 0; i < count; ++i) {
            result.add(StorageTaskSubpoolStatisticsEntry.create(this.data, datastart + i * 36, 36));
        }
        return Collections.unmodifiableList(result);
    }

    public static StorageTaskSubpoolStatistics create(byte[] Data2, int offset, int length) {
        return new StorageTaskSubpoolStatistics(Data2, offset, length);
    }

    static enum Field {
        smtlen(0, 2),
        smtid(2, 2),
        smtdvers(4, 1),
        smtntask(8, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

