/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum D2gPoolPriority {
    NA(0),
    HIGH(1),
    EQUAL(2),
    LOW(3),
    NOT_DEFINED(-16);

    private static Map<Integer, D2gPoolPriority> valueMap;
    private final int d2gpoolpriority;

    private D2gPoolPriority(int d2gpoolpriority) {
        this.d2gpoolpriority = d2gpoolpriority;
    }

    public static D2gPoolPriority from(int value) {
        D2gPoolPriority result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int d2gpoolpriority() {
        return this.d2gpoolpriority;
    }

    static {
        valueMap = new HashMap<Integer, D2gPoolPriority>();
        for (D2gPoolPriority x : D2gPoolPriority.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.d2gpoolpriority, x);
        }
    }
}

