/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum IsrUserauth {
    DEFAULTUSER(1),
    IDENTIFY(2),
    LOCAL(3),
    VERIFY(4),
    NOT_DEFINED(-16);

    private static Map<Integer, IsrUserauth> valueMap;
    private final int isruserauth;

    private IsrUserauth(int isruserauth) {
        this.isruserauth = isruserauth;
    }

    public static IsrUserauth from(int value) {
        IsrUserauth result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int isruserauth() {
        return this.isruserauth;
    }

    static {
        valueMap = new HashMap<Integer, IsrUserauth>();
        for (IsrUserauth x : IsrUserauth.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.isruserauth, x);
        }
    }
}

