/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum SmtAccess {
    CICS(1),
    USER(2),
    NOT_DEFINED(-16);

    private static Map<Integer, SmtAccess> valueMap;
    private final int smtaccess;

    private SmtAccess(int smtaccess) {
        this.smtaccess = smtaccess;
    }

    public static SmtAccess from(int value) {
        SmtAccess result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int smtaccess() {
        return this.smtaccess;
    }

    static {
        valueMap = new HashMap<Integer, SmtAccess>();
        for (SmtAccess x : SmtAccess.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.smtaccess, x);
        }
    }
}

