/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum TmrNatur {
    NA(0),
    TERMINAL(1),
    SESSION(2),
    NOT_DEFINED(-16);

    private static Map<Integer, TmrNatur> valueMap;
    private final int tmrnatur;

    private TmrNatur(int tmrnatur) {
        this.tmrnatur = tmrnatur;
    }

    public static TmrNatur from(int value) {
        TmrNatur result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tmrnatur() {
        return this.tmrnatur;
    }

    static {
        valueMap = new HashMap<Integer, TmrNatur>();
        for (TmrNatur x : TmrNatur.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tmrnatur, x);
        }
    }
}

