/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum TqrFtype {
    NA(0),
    TERMINAL(1),
    SYSTEM(2),
    NO_TERMINAL(3),
    NOT_DEFINED(-16);

    private static Map<Integer, TqrFtype> valueMap;
    private final int tqrftype;

    private TqrFtype(int tqrftype) {
        this.tqrftype = tqrftype;
    }

    public static TqrFtype from(int value) {
        TqrFtype result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tqrftype() {
        return this.tqrftype;
    }

    static {
        valueMap = new HashMap<Integer, TqrFtype>();
        for (TqrFtype x : TqrFtype.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tqrftype, x);
        }
    }
}

