/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.controlblock;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.controlblock.CapacityChangeReason;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.values.BoostClass;
import java.math.BigInteger;
import java.time.ZonedDateTime;

final class Rmctz
extends SmfData {
    public static final int RMCTZ_LPARMgmt_Enabled = 128;
    public static final int RMCTZ_LPAR_VaryCPU_Enabled = 64;
    public static final int RMCTZ_ABN_OPT = 128;
    public static final int RMCTZ_Manage_NonEnclave_Work = 64;
    public static final int RMCTZ_OPT_AIMANAGEMENT = 32;
    public static final int RMCTZ_VCM_OPT = 128;
    public static final int RMCTZ_VCM = 64;
    public static final int RMCTZ_IOMS = 32;
    public static final int RMCTZ_FullPreSystem = 16;
    public static final int RMCTZ_ABSMSUCAPPING = 8;
    public static final int RMCTZ_SUPPSAFINFOMSG = 4;
    public static final int RMCTZ_zIIPBoost_Active = 128;
    public static final int RMCTZ_SpeedBoost_Active = 64;
    public static final int RMCTZ_IPLBoost_Activated = 32;
    public static final int RMCTZ_SDBoost_Activated = 16;
    public static final int RMCTZ_RPBoost_Activated = 8;
    public static final int RMCTZ_BoostClass = 7;
    public static final int RMCTZ_Procview = 128;
    public static final int RMCTZ_MT = 64;
    public static final int RMCTZ_WLMIRDSTRUC_SET = 128;
    public static final int RMCTZ_RMF_CPU_sampling_table_value = 40;
    public static final int RMCTZ_CAI_no_indication = 0;
    public static final int RMCTZ_CAI_normal = 100;
    public static final int RMCTZ_BoostClass_Mask = 7;

    private Rmctz(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String rmctzName() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public int rmctzVersion() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int rmctzLength() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int rmctzLparFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public boolean rmctzLPARMgmtEnabled() {
        return Util.ConvertFlag(this.data, this.rmctzLparFlags(), 128);
    }

    public boolean rmctzLparVaryCPUEnabled() {
        return Util.ConvertFlag(this.data, this.rmctzLparFlags(), 64);
    }

    public int rmctzFlag1() {
        return Util.ConvertUnsignedBinary1(this.data, 13);
    }

    public boolean rmctzAbnOpt() {
        return Util.ConvertFlag(this.data, this.rmctzFlag1(), 128);
    }

    public boolean rmctzManageNonEnclaveWork() {
        return Util.ConvertFlag(this.data, this.rmctzFlag1(), 64);
    }

    public boolean rmctzOptAimanagement() {
        return Util.ConvertFlag(this.data, this.rmctzFlag1(), 32);
    }

    public int rmctzFlag2() {
        return Util.ConvertUnsignedBinary1(this.data, 14);
    }

    public boolean rmctzVcmOpt() {
        return Util.ConvertFlag(this.data, this.rmctzFlag2(), 128);
    }

    public boolean rmctzVcm() {
        return Util.ConvertFlag(this.data, this.rmctzFlag2(), 64);
    }

    public boolean rmctzIoms() {
        return Util.ConvertFlag(this.data, this.rmctzFlag2(), 32);
    }

    public boolean rmctzFullPreSystem() {
        return Util.ConvertFlag(this.data, this.rmctzFlag2(), 16);
    }

    public boolean rmctzAbsmsucapping() {
        return Util.ConvertFlag(this.data, this.rmctzFlag2(), 8);
    }

    public boolean rmctzSuppsafinfomsg() {
        return Util.ConvertFlag(this.data, this.rmctzFlag2(), 4);
    }

    public int rmctzInitimpDp() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public int rmctzInitimp() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public int rmctzLparVaryCpuMin() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    public int rmctzWasRoutingLevel() {
        return Util.ConvertUnsignedBinary1(this.data, 21);
    }

    public ZonedDateTime rmctzCapacityChangeTime() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger rmctzCapacityChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public int rmctzCapacityAdjustmentIndication() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public CapacityChangeReason rmctzCapacityChangeReason() {
        int value = Util.ConvertUnsignedBinary1(this.data, 33);
        return CapacityChangeReason.from(value);
    }

    public int rmctzCapacityChangeReasonRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 33);
    }

    public int rmctzCaiIpl() {
        return Util.ConvertUnsignedBinary1(this.data, 34);
    }

    public CapacityChangeReason rmctzCcrIpl() {
        int value = Util.ConvertUnsignedBinary1(this.data, 35);
        return CapacityChangeReason.from(value);
    }

    public int rmctzCcrIplRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 35);
    }

    public long rmctzNominalCpmp() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long rmctzRmfCpuSamplingIndex() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long rmctzAdjcCec() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long rmctzCecCapacity() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public int rmctzIomsOpt() {
        return Util.ConvertUnsignedBinary1(this.data, 52);
    }

    public ZonedDateTime rmctzLastPaTod() {
        return Util.Binary8xStckTime(this.data, 56);
    }

    public BigInteger rmctzLastPaTodRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long rmctzSUsZiip() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger rmctzSUsZiipAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long rmctzSUsZiipOnCp() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger rmctzSUsZiipOnCpAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long rmctzSUsJavaOnZiip() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger rmctzSUsJavaOnZiipAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long rmctzSUsJavaOnCp() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger rmctzSUsJavaOnCpAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public int rmctzRoutingPiFactorPercentage() {
        return Util.ConvertUnsignedBinary1(this.data, 1260);
    }

    public int rmctzBoostInfo() {
        return Util.ConvertUnsignedBinary1(this.data, 1261);
    }

    public boolean rmctzZIIPBoostActive() {
        return Util.ConvertFlag(this.data, this.rmctzBoostInfo(), 128);
    }

    public boolean rmctzSpeedBoostActive() {
        return Util.ConvertFlag(this.data, this.rmctzBoostInfo(), 64);
    }

    public boolean rmctzIPLBoostActivated() {
        return Util.ConvertFlag(this.data, this.rmctzBoostInfo(), 32);
    }

    public boolean rmctzSDBoostActivated() {
        return Util.ConvertFlag(this.data, this.rmctzBoostInfo(), 16);
    }

    public boolean rmctzRPBoostActivated() {
        return Util.ConvertFlag(this.data, this.rmctzBoostInfo(), 8);
    }

    public BoostClass smf30BoostClass() {
        if (this.rmctzZIIPBoostActive() || this.rmctzSpeedBoostActive()) {
            return BoostClass.from(this.rmctzBoostInfo() & 7);
        }
        return null;
    }

    public int rmctzMtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 1264);
    }

    public boolean rmctzProcview() {
        return Util.ConvertFlag(this.data, this.rmctzMtFlags(), 128);
    }

    public boolean rmctzMt() {
        return Util.ConvertFlag(this.data, this.rmctzMtFlags(), 64);
    }

    public int rmctzMtCp() {
        return Util.ConvertUnsignedBinary1(this.data, 1268);
    }

    public int rmctzMtZaap() {
        return Util.ConvertUnsignedBinary1(this.data, 1269);
    }

    public int rmctzMtZiip() {
        return Util.ConvertUnsignedBinary1(this.data, 1270);
    }

    public int rmctzMtOptCp() {
        return Util.ConvertUnsignedBinary1(this.data, 1272);
    }

    public int rmctzMtOptZaap() {
        return Util.ConvertUnsignedBinary1(this.data, 1273);
    }

    public int rmctzMtOptZiip() {
        return Util.ConvertUnsignedBinary1(this.data, 1274);
    }

    public long rmctzCpuAlivePrevOptCoreMode() {
        return Util.ConvertUnsignedBinary4(this.data, 1276);
    }

    public int rmctzWlmirdstruc() {
        return Util.ConvertUnsignedBinary2(this.data, 1280);
    }

    public int rmctzFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 1282);
    }

    public boolean rmctzWlmirdstrucSet() {
        return Util.ConvertFlag(this.data, this.rmctzFlags(), 128);
    }

    public long rmctzRTCapLeadTime() {
        return Util.ConvertUnsignedBinary4(this.data, 1288);
    }

    public int rmctzTimeToCap() {
        return Util.ConvertUnsignedBinary2(this.data, 1292);
    }

    public int rmctzTimeToCapGroup() {
        return Util.ConvertUnsignedBinary2(this.data, 1294);
    }

    public long rmctzDiag204FailureCount() {
        return Util.ConvertUnsignedBinary4(this.data, 1296);
    }

    public static Rmctz create(byte[] Data2, int offset, int length) {
        return new Rmctz(Data2, offset, length);
    }

    static enum Field {
        rmctzName(0, 8),
        rmctzVersion(8, 1),
        rmctzLength(10, 2),
        rmctzLparFlags(12, 1),
        rmctzFlag1(13, 1),
        rmctzFlag2(14, 1),
        rmctzInitimpDp(16, 2),
        rmctzInitimp(18, 2),
        rmctzLparVaryCpuMin(20, 1),
        rmctzWasRoutingLevel(21, 1),
        rmctzCapacityChangeTime(24, 8),
        rmctzCapacityAdjustmentIndication(32, 1),
        rmctzCapacityChangeReason(33, 1),
        rmctzCaiIpl(34, 1),
        rmctzCcrIpl(35, 1),
        rmctzNominalCpmp(36, 4),
        rmctzRmfCpuSamplingIndex(40, 4),
        rmctzAdjcCec(44, 4),
        rmctzCecCapacity(48, 4),
        rmctzIomsOpt(52, 1),
        rmctzLastPaTod(56, 8),
        rmctzSUsZiip(64, 8),
        rmctzSUsZiipOnCp(72, 8),
        rmctzSUsJavaOnZiip(80, 8),
        rmctzSUsJavaOnCp(88, 8),
        rmctzRoutingPiFactorPercentage(1260, 1),
        rmctzBoostInfo(1261, 1),
        rmctzMtFlags(1264, 1),
        rmctzMtCp(1268, 1),
        rmctzMtZaap(1269, 1),
        rmctzMtZiip(1270, 1),
        rmctzMtOptCp(1272, 1),
        rmctzMtOptZaap(1273, 1),
        rmctzMtOptZiip(1274, 1),
        rmctzCpuAlivePrevOptCoreMode(1276, 4),
        rmctzWlmirdstruc(1280, 2),
        rmctzFlags(1282, 1),
        rmctzRTCapLeadTime(1288, 4),
        rmctzTimeToCap(1292, 2),
        rmctzTimeToCapGroup(1294, 2),
        rmctzDiag204FailureCount(1296, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

