/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.util.Arrays;

public final class LuwId
extends SmfData {
    private final int LUWIDOFFSET;

    private LuwId(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        this.LUWIDOFFSET = offset;
    }

    @Override
    public String toString() {
        return String.format("%-8s%-8s%012X%04X", this.qwhsnid(), this.qwhslunm(), this.qwhsluuv(), this.qwhslucc());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toHexString() {
        int hexlength = this.data.length * 2;
        BigInteger temp = Util.ConvertBigInteger(this.data, 0, this.data.length);
        return String.format("%0" + Integer.toString(hexlength) + "X", temp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LuwId other = (LuwId)obj;
        return Arrays.equals(this.data, other.data);
    }

    public String qwhsnid() {
        return Util.ConvertEbcdic(this.data, 52 - this.LUWIDOFFSET, 8);
    }

    public String qwhslunm() {
        return Util.ConvertEbcdic(this.data, 60 - this.LUWIDOFFSET, 8);
    }

    public long qwhsluuv() {
        return Util.ConvertUnsignedBinary6(this.data, 68 - this.LUWIDOFFSET);
    }

    public int qwhslucc() {
        return Util.ConvertUnsignedBinary2(this.data, 74 - this.LUWIDOFFSET);
    }

    public static LuwId create(byte[] Data2, int offset, int length) {
        return new LuwId(Data2, offset, length);
    }
}

