/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Smf102Record
extends SmfDb2Record {
    public static final int SM102CMP = 128;
    public static final int SM102END = 28;

    public Smf102Record(byte[] data) {
        super(data);
        if (this.recordType() != 102) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf102Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 102) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf102Record from(SmfRecord record) {
        return new Smf102Record(record);
    }

    public static Smf102Record from(byte[] data) {
        return new Smf102Record(data);
    }

    public int sm102len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sm102sgd() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sm102flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int sm102rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime sm102tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long sm102tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate sm102dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int sm102dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String sm102sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String sm102ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int sm102stf() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long sm102seq() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public boolean sm102cmp() {
        return Util.ConvertFlag(this.data, this.sm102seq(), 128, Field.sm102seq.length, 0);
    }

    public long sm102buf() {
        return Util.ConvertUnsignedBinary4(this.data, 24, Short.MAX_VALUE);
    }

    static enum Field {
        sm102len(0, 2),
        sm102sgd(2, 2),
        sm102flg(4, 1),
        sm102rty(5, 1),
        sm102tme(6, 4),
        sm102dte(10, 4),
        sm102sid(14, 4),
        sm102ssi(18, 4),
        sm102stf(22, 2),
        sm102seq(24, 4),
        sm102buf(24, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

