/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.db2.Smf100Record;
import com.blackhillsoftware.smf.db2.Smf101Record;
import com.blackhillsoftware.smf.db2.Smf102Record;
import com.blackhillsoftware.smf.db2.section.Qwha;
import com.blackhillsoftware.smf.db2.section.Qwhc;
import com.blackhillsoftware.smf.db2.section.Qwhd;
import com.blackhillsoftware.smf.db2.section.Qwhs;
import com.blackhillsoftware.smf.db2.section.Qwht;
import com.blackhillsoftware.smf.db2.section.Qwhu;
import com.blackhillsoftware.smf.internal.CreateDb2Section;
import com.blackhillsoftware.smf.internal.Csrcesrv;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;

public class SmfDb2Record
extends SmfRecord {
    private int originalDb2Buf = 0;
    public static final int SMFDB2CMP = 128;
    public static final int SMFDB2END = 28;
    private Qwhc m_qwhc = null;
    private byte[] originalData = null;
    private Qwhs m_qwhs = null;
    private Qwht m_qwht = null;
    private Qwhu m_qwhu = null;
    private Qwhd m_qwhd = null;
    private Qwha m_qwha = null;

    public SmfDb2Record(byte[] data) {
        super(data);
        this.originalData = data;
        this.checkCompression();
    }

    public SmfDb2Record(SmfRecord record) {
        super(record);
        if (record instanceof SmfDb2Record) {
            this.originalData = ((SmfDb2Record)record).originalData;
        } else {
            this.originalData = this.data;
            this.checkCompression();
        }
    }

    public static SmfDb2Record from(SmfRecord record) {
        switch (record.recordType()) {
            case 100: {
                return new Smf100Record(record);
            }
            case 101: {
                return new Smf101Record(record);
            }
            case 102: {
                return new Smf102Record(record);
            }
        }
        return new SmfDb2Record(record);
    }

    public static SmfDb2Record from(byte[] data) {
        switch (SmfRecord.recordType(data)) {
            case 100: {
                return new Smf100Record(data);
            }
            case 101: {
                return new Smf101Record(data);
            }
            case 102: {
                return new Smf102Record(data);
            }
        }
        return new SmfDb2Record(data);
    }

    private void checkCompression() {
        if (this.smfDb2cmp()) {
            int bufferlength;
            this.originalDb2Buf = bufferlength = (int)this.smfDb2buf();
            byte[] newdata = new byte[28 + bufferlength];
            System.arraycopy(this.data, 0, newdata, 0, 28);
            Csrcesrv.decompress(this.data, newdata, 28, this.data.length - 28, 28, bufferlength);
            Arrays.fill(newdata, 24, 28, (byte)0);
            Util.WriteUnsignedBinary2(newdata, 0, newdata.length);
            this.data = newdata;
        }
    }

    public SmfDb2Record decompress() {
        this.checkCompression();
        switch (this.recordType()) {
            case 100: {
                return new Smf100Record(this.data);
            }
            case 101: {
                return new Smf101Record(this.data);
            }
            case 102: {
                return new Smf102Record(this.data);
            }
        }
        return new SmfDb2Record(this.data);
    }

    public boolean usedCompression() {
        return this.originalDb2Buf > 0 || this.smfDb2buf() > 0L;
    }

    @Override
    protected byte[] getDataArray() {
        return this.originalData;
    }

    public int smfDb2len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smfDb2sgd() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smfDb2flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smfDb2rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smfDb2tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smfDb2tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smfDb2dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smfDb2dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smfDb2sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smfDb2ssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smfDb2stf() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public long smfDb2seq() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public boolean smfDb2cmp() {
        return Util.ConvertFlag(this.data, this.smfDb2seq(), 128, Field.smfDb2seq.length, 0);
    }

    public long smfDb2buf() {
        return Util.ConvertUnsignedBinary4(this.data, 24, Short.MAX_VALUE);
    }

    public int ifcid() {
        return this.qwhs().qwhsiid();
    }

    public Qwhs qwhs() {
        if (this.m_qwhs == null) {
            Triplet ps = this.getProductSectionTriplet();
            this.m_qwhs = Qwhs.create(this.data, ps.getOffset(), ps.getLength());
        }
        return this.m_qwhs;
    }

    private Triplet getProductSectionTriplet() {
        return this.getTriplet(28);
    }

    public Qwhc qwhc() {
        if (this.m_qwhc == null) {
            this.m_qwhc = this.getHeader(2, Qwhc::create);
        }
        return this.m_qwhc;
    }

    public Qwht qwht() {
        if (this.m_qwht == null) {
            this.m_qwht = this.getHeader(4, Qwht::create);
        }
        return this.m_qwht;
    }

    public Qwhu qwhu() {
        if (this.m_qwhu == null) {
            this.m_qwhu = this.getHeader(8, Qwhu::create);
        }
        return this.m_qwhu;
    }

    public Qwhd qwhd() {
        if (this.m_qwhd == null) {
            this.m_qwhd = this.getHeader(16, Qwhd::create);
        }
        return this.m_qwhd;
    }

    public Qwha qwha() {
        if (this.m_qwha == null) {
            this.m_qwha = this.getHeader(32, Qwha::create);
        }
        return this.m_qwha;
    }

    private <T> T getHeader(int targettype, CreateDb2Section<T> builder) {
        int nextLength;
        T result = null;
        Triplet ps = this.getProductSectionTriplet();
        int productSectionOffset = ps.getOffset();
        int productSectionLength = ps.getLength();
        for (int offset = productSectionOffset + Util.ConvertUnsignedBinary2(this.data, productSectionOffset); offset < productSectionOffset + productSectionLength; offset += nextLength) {
            nextLength = Util.ConvertUnsignedBinary2(this.data, offset);
            int type = Util.ConvertUnsignedBinary1(this.data, offset + Qwhs.Field.qwhstyp.offset);
            if (type != targettype) continue;
            result = builder.createSection(this.data, offset, nextLength, this);
            break;
        }
        return result;
    }

    protected <T> List<T> db2Sections(List<T> current, byte[] data, IntFunction<Triplet> tripletSupplier, int tripletOffset, CreateDb2Section<T> builder, int ifcid) {
        if (current != null) {
            return current;
        }
        if (this.ifcid() != ifcid) {
            return Collections.emptyList();
        }
        return this.db2Sections(current, data, tripletSupplier, tripletOffset, builder);
    }

    protected <T> List<T> db2Sections(List<T> current, byte[] data, IntFunction<Triplet> tripletSupplier, int tripletOffset, CreateDb2Section<T> builder) {
        if (current != null) {
            return current;
        }
        Triplet t = tripletSupplier.apply(tripletOffset);
        if (t.getCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(t.getCount());
        int offset = t.getOffset();
        int length = t.getLength();
        if (length == 0) {
            length = Util.ConvertUnsignedBinary2(data, offset);
            result.add(builder.createSection(data, offset + 2, length, this));
            offset += length + 2;
        } else {
            for (int i = 0; i < t.getCount(); ++i) {
                result.add(builder.createSection(data, offset + i * length, length, this));
            }
        }
        return Collections.unmodifiableList(result);
    }

    static enum Field {
        smfDb2len(0, 2),
        smfDb2sgd(2, 2),
        smfDb2flg(4, 1),
        smfDb2rty(5, 1),
        smfDb2tme(6, 4),
        smfDb2dte(10, 4),
        smfDb2sid(14, 4),
        smfDb2ssi(18, 4),
        smfDb2stf(22, 2),
        smfDb2seq(24, 4),
        smfDb2buf(24, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

