/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2.section;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.db2.section.QlaclocnD;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class Qlac
extends SmfData {
    private boolean utf8;
    private QlaclocnD m_QlaclocnD = null;
    public static final int QLACFLG0 = 128;
    public static final int QLACFLG1 = 64;
    public static final int QLACFLG2 = 32;
    public static final int QLACFLG3 = 16;
    public static final int QLACFLG4 = 8;
    public static final int QLACFLG5 = 4;
    public static final int QLACFLG6 = 2;
    public static final int QLACFLG7 = 1;
    public static final int QLACEND = 216;

    private Qlac(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        super(Data2, offset, length);
        this.utf8 = parent.qwhs().qwhsUnicode();
    }

    public int qlaclocnOff() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int qlacflgs() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean qlacflg0() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 128);
    }

    public boolean qlacflg1() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 64);
    }

    public boolean qlacflg2() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 32);
    }

    public boolean qlacflg3() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 16);
    }

    public boolean qlacflg4() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 8);
    }

    public boolean qlacflg5() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 4);
    }

    public boolean qlacflg6() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 2);
    }

    public boolean qlacflg7() {
        return Util.ConvertFlag(this.data, this.qlacflgs(), 1);
    }

    public long qlacrlnu() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public String qlaclocn() {
        if (this.m_QlaclocnD != null) {
            return this.m_QlaclocnD.qlaclocnVar();
        }
        return Util.ConvertEbcdicOrUtf8(this.data, 8, 16, this.utf8);
    }

    public String qlacprid() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public long qlaccnvs() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger qlaccnvsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long qlaccnvt() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger qlaccnvtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long qlaccnvr() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger qlaccnvrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long qlacmsgs() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger qlacmsgsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long qlacmsgr() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger qlacmsgrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long qlacsqls() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger qlacsqlsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long qlacsqlr() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger qlacsqlrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long qlacbyts() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger qlacbytsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long qlacbytr() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger qlacbytrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long qlacrows() {
        return Util.ConvertUnsignedBinary8(this.data, 104);
    }

    public BigInteger qlacrowsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long qlacrowr() {
        return Util.ConvertUnsignedBinary8(this.data, 112);
    }

    public BigInteger qlacrowrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public long qlacbtbf() {
        return Util.ConvertUnsignedBinary8(this.data, 120);
    }

    public BigInteger qlacbtbfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public long qlacbrbf() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger qlacbrbfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long qlaccoms() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger qlaccomsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long qlaccomr() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger qlaccomrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public long qlacabrs() {
        return Util.ConvertUnsignedBinary8(this.data, 152);
    }

    public BigInteger qlacabrsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 152);
    }

    public long qlacabrr() {
        return Util.ConvertUnsignedBinary8(this.data, 160);
    }

    public BigInteger qlacabrrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 160);
    }

    public long qlacindt() {
        return Util.ConvertUnsignedBinary8(this.data, 168);
    }

    public BigInteger qlacindtAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 168);
    }

    public long qlaccnvq() {
        return Util.ConvertUnsignedBinary8(this.data, 176);
    }

    public BigInteger qlaccnvqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 176);
    }

    public Duration qlaccpul() {
        return Util.Binary8StckInterval(this.data, 184);
    }

    public double qlaccpulSeconds() {
        return Util.ToSeconds(this.qlaccpul());
    }

    public long qlaccpulRawValue() {
        return Util.ConvertSignedBinary8(this.data, 184);
    }

    public Duration qlacmdwt() {
        return Util.Binary8StckInterval(this.data, 192);
    }

    public double qlacmdwtSeconds() {
        return Util.ToSeconds(this.qlacmdwt());
    }

    public long qlacmdwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 192);
    }

    public String qlacprlv() {
        return Util.ConvertEbcdic(this.data, 200, 16);
    }

    public static Qlac create(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        return new Qlac(Data2, offset, length, parent);
    }

    static enum Field {
        qlaclocnOff(0, 2),
        qlacflgs(2, 1),
        qlacrlnu(4, 4),
        qlaclocn(8, 16),
        qlacprid(24, 8),
        qlaccnvs(32, 8),
        qlaccnvt(40, 8),
        qlaccnvr(48, 8),
        qlacmsgs(56, 8),
        qlacmsgr(64, 8),
        qlacsqls(72, 8),
        qlacsqlr(80, 8),
        qlacbyts(88, 8),
        qlacbytr(96, 8),
        qlacrows(104, 8),
        qlacrowr(112, 8),
        qlacbtbf(120, 8),
        qlacbrbf(128, 8),
        qlaccoms(136, 8),
        qlaccomr(144, 8),
        qlacabrs(152, 8),
        qlacabrr(160, 8),
        qlacindt(168, 8),
        qlaccnvq(176, 8),
        qlaccpul(184, 8),
        qlacmdwt(192, 8),
        qlacprlv(200, 16);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

