/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import com.blackhillsoftware.smf.internal.Conversions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConversionsInternal
extends Conversions {
    ConversionsInternal() {
    }

    @Override
    float ConvertFloat(byte[] data, int offset) {
        return ConversionsInternal.ConvertFloatToIEEE(data, offset);
    }

    @Override
    double ConvertDouble(byte[] data, int offset) {
        return ConversionsInternal.ConvertDoubleToIEEE(data, offset);
    }

    @Override
    int ConvertUnsignedBinary2(byte[] data, int offset) {
        int value = (data[offset++] & 0xFF) << 8;
        return value ^= data[offset] & 0xFF;
    }

    @Override
    int ConvertUnsignedBinary3(byte[] data, int offset) {
        int value = (data[offset++] & 0xFF) << 16;
        value ^= (data[offset++] & 0xFF) << 8;
        return value ^= data[offset] & 0xFF;
    }

    @Override
    long ConvertUnsignedBinary4(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value ^= (long)(data[offset] & 0xFF);
    }

    @Override
    long ConvertUnsignedBinary5(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value ^= (long)(data[offset] & 0xFF);
    }

    @Override
    long ConvertUnsignedBinary6(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value ^= (long)(data[offset] & 0xFF);
    }

    @Override
    long ConvertUnsignedBinary7(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 48;
        value ^= (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value ^= (long)(data[offset] & 0xFF);
    }

    @Override
    long ConvertUnsignedBinary8(byte[] data, int offset) {
        if ((data[offset] & 0x80) == 128) {
            throw new IllegalArgumentException("Unsigned binary 8 value overflows signed field");
        }
        long value = (long)(data[offset++] & 0xFF) << 56;
        value ^= (long)(data[offset++] & 0xFF) << 48;
        value ^= (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value ^= (long)(data[offset] & 0xFF);
    }

    @Override
    int ConvertSignedBinary2(byte[] data, int offset) {
        int value = (data[offset++] & 0xFF) << 24;
        value ^= (data[offset++] & 0xFF) << 16;
        return value >>= 16;
    }

    @Override
    int ConvertSignedBinary3(byte[] data, int offset) {
        int value = (data[offset++] & 0xFF) << 24;
        value ^= (data[offset++] & 0xFF) << 16;
        value ^= (data[offset++] & 0xFF) << 8;
        return value >>= 8;
    }

    @Override
    int ConvertSignedBinary4(byte[] data, int offset) {
        int value = (data[offset++] & 0xFF) << 24;
        value ^= (data[offset++] & 0xFF) << 16;
        value ^= (data[offset++] & 0xFF) << 8;
        return value ^= data[offset] & 0xFF;
    }

    @Override
    long ConvertSignedBinary5(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 56;
        value ^= (long)(data[offset++] & 0xFF) << 48;
        value ^= (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        return value >>= 24;
    }

    @Override
    long ConvertSignedBinary6(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 56;
        value ^= (long)(data[offset++] & 0xFF) << 48;
        value ^= (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        return value >>= 16;
    }

    @Override
    long ConvertSignedBinary7(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 56;
        value ^= (long)(data[offset++] & 0xFF) << 48;
        value ^= (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value >>= 8;
    }

    @Override
    long ConvertSignedBinary8(byte[] data, int offset) {
        long value = (long)(data[offset++] & 0xFF) << 56;
        value ^= (long)(data[offset++] & 0xFF) << 48;
        value ^= (long)(data[offset++] & 0xFF) << 40;
        value ^= (long)(data[offset++] & 0xFF) << 32;
        value ^= (long)(data[offset++] & 0xFF) << 24;
        value ^= (long)(data[offset++] & 0xFF) << 16;
        value ^= (long)(data[offset++] & 0xFF) << 8;
        return value ^= (long)(data[offset] & 0xFF);
    }

    @Override
    int ConvertPacked1(byte[] data, int offset) {
        int result = (data[offset] & 0xF0) >> 4;
        switch (data[offset] & 0xF) {
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 13: {
                result *= -1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Packed Decimal data: %02X", this.ConvertUnsignedBinary1(data, offset)));
            }
        }
        return result;
    }

    @Override
    int ConvertPacked2(byte[] data, int offset) {
        int result = (data[offset + 1] & 0xF0) >> 4;
        int digit = 10;
        int work = data[offset] & 0xF;
        result += work * digit;
        work = (data[offset] & 0xF0) >> 4;
        result += work * (digit *= 10);
        work = data[offset + 1] & 0xF;
        switch (work) {
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 13: {
                result *= -1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Packed Decimal data: %04X", this.ConvertUnsignedBinary2(data, offset)));
            }
        }
        return result;
    }

    @Override
    int ConvertPacked3(byte[] data, int offset) {
        int work;
        int length = 3;
        int result = (data[offset + length - 1] & 0xF0) >> 4;
        int digit = 10;
        for (int i = length - 2; i >= 0; --i) {
            work = data[offset + i] & 0xF;
            result += work * digit;
            work = (data[offset + i] & 0xF0) >> 4;
            result += work * (digit *= 10);
            digit *= 10;
        }
        work = data[offset + length - 1] & 0xF;
        switch (work) {
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 13: {
                result *= -1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Packed Decimal data: %06X", this.ConvertUnsignedBinary3(data, offset)));
            }
        }
        return result;
    }

    @Override
    int ConvertPacked4(byte[] data, int offset) {
        int work;
        int length = 4;
        int result = (data[offset + length - 1] & 0xF0) >> 4;
        int digit = 10;
        for (int i = length - 2; i >= 0; --i) {
            work = data[offset + i] & 0xF;
            result += work * digit;
            work = (data[offset + i] & 0xF0) >> 4;
            result += work * (digit *= 10);
            digit *= 10;
        }
        work = data[offset + length - 1] & 0xF;
        switch (work) {
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 13: {
                result *= -1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Packed Decimal data: %08X", this.ConvertUnsignedBinary4(data, offset)));
            }
        }
        return result;
    }

    @Override
    long ConvertPackedLong(byte[] data, int offset, int length) {
        int work;
        if (length > 9) {
            throw new ArithmeticException("Packed field too large: " + Integer.toString(length));
        }
        long result = (data[offset + length - 1] & 0xF0) >> 4;
        long digit = 10L;
        for (int i = length - 2; i >= 0; --i) {
            work = data[offset + i] & 0xF;
            result += (long)work * digit;
            work = (data[offset + i] & 0xF0) >> 4;
            result += (long)work * (digit *= 10L);
            digit *= 10L;
        }
        work = data[offset + length - 1] & 0xF;
        switch (work) {
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 13: {
                result *= -1L;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Packed Decimal data: %08X", this.ConvertUnsignedBinary4(data, offset)));
            }
        }
        return result;
    }

    @Override
    BigInteger ConvertPackedBigInteger(byte[] data, int offset, int length) {
        if (length > 16) {
            throw new ArithmeticException("Packed field too large: " + Integer.toString(length));
        }
        int maxLongPackedLength = 9;
        int rightPartLength = Math.min(length, maxLongPackedLength);
        long rightpart = this.ConvertPackedLong(data, offset + length - rightPartLength, rightPartLength);
        long leftpart = 0L;
        if (length > maxLongPackedLength) {
            leftpart = this.ConvertPackedNoSign(data, offset, length - rightPartLength);
        }
        BigInteger result = BigInteger.valueOf(rightpart);
        if (leftpart != 0L) {
            result = rightpart >= 0L ? result.add(BigInteger.valueOf(leftpart).multiply(BigInteger.valueOf(10L).pow(17))) : result.subtract(BigInteger.valueOf(leftpart).multiply(BigInteger.valueOf(10L).pow(17)));
        }
        return result;
    }

    @Override
    BigInteger ConvertUnsignedBinary8BigInteger(byte[] data, int offset) {
        byte[] work = new byte[8];
        System.arraycopy(data, offset, work, 0, 8);
        BigInteger result = new BigInteger(1, work);
        return result;
    }

    @Override
    BigInteger ConvertUnsignedBinary4BigInteger(byte[] data, int offset) {
        byte[] work = new byte[4];
        System.arraycopy(data, offset, work, 0, 4);
        BigInteger result = new BigInteger(1, work);
        return result;
    }

    @Override
    BigInteger ConvertUnsignedBinary2BigInteger(byte[] data, int offset) {
        byte[] work = new byte[2];
        System.arraycopy(data, offset, work, 0, 2);
        BigInteger result = new BigInteger(1, work);
        return result;
    }

    @Override
    BigInteger ConvertBigInteger(byte[] data, int offset, int length) {
        byte[] work = new byte[length];
        System.arraycopy(data, offset, work, 0, length);
        BigInteger result = new BigInteger(1, work);
        return result;
    }

    @Override
    BigInteger ConvertSignedBigInteger(byte[] data, int offset, int length) {
        byte[] work = new byte[length];
        System.arraycopy(data, offset, work, 0, length);
        BigInteger result = new BigInteger(work);
        return result;
    }

    private static float ConvertFloatToIEEE(byte[] data, int offset) {
        int x = (data[offset++] & 0xFF) << 24;
        x ^= (data[offset++] & 0xFF) << 16;
        x ^= (data[offset++] & 0xFF) << 8;
        if ((x ^= data[offset] & 0xFF) == 0) {
            return 0.0f;
        }
        if (x == Integer.MIN_VALUE) {
            return -0.0f;
        }
        int s = x & Integer.MIN_VALUE;
        int e = ((x & 0x7F000000) >> 24) - 64;
        int f = x & 0xFFFFFF;
        e = e >= 0 ? (e <<= 2) : -(-e << 2);
        --e;
        if (f != 0) {
            int leadingzeros = Integer.numberOfLeadingZeros(f);
            if (leadingzeros > 8) {
                f <<= leadingzeros - 8;
                e -= leadingzeros - 8;
            }
            if (e + 127 <= 0) {
                int bitsToShift = -1 * e - 127 + 1;
                f = bitsToShift <= 24 ? (f >>= bitsToShift) : 0;
                e = -127;
            }
        }
        f &= 0x7FFFFF;
        if ((e += 127) >= 255) {
            return s == 0 ? Float.MAX_VALUE : -3.4028235E38f;
        }
        ByteBuffer b = ByteBuffer.allocate(4).putInt(s | e << 23 | f);
        return b.getFloat(0);
    }

    private static double ConvertDoubleToIEEE(byte[] data, int offset) {
        long x = (long)(data[offset++] & 0xFF) << 56;
        x ^= (long)(data[offset++] & 0xFF) << 48;
        x ^= (long)(data[offset++] & 0xFF) << 40;
        x ^= (long)(data[offset++] & 0xFF) << 32;
        x ^= (long)(data[offset++] & 0xFF) << 24;
        x ^= (long)(data[offset++] & 0xFF) << 16;
        x ^= (long)(data[offset++] & 0xFF) << 8;
        if ((x ^= (long)(data[offset] & 0xFF)) == 0L) {
            return 0.0;
        }
        if (x == Long.MIN_VALUE) {
            return -0.0;
        }
        long s = x & Long.MIN_VALUE;
        long e = ((x & 0x7F00000000000000L) >> 56) - 64L;
        long f = x & 0xFFFFFFFFFFFFFFL;
        e = e >= 0L ? (e <<= 2) : -(-e << 2);
        if (f != 0L) {
            int leadingzeros = Long.numberOfLeadingZeros(f);
            if (leadingzeros > 7) {
                f <<= leadingzeros - 7;
                e -= (long)(leadingzeros - 7);
            }
            if (e + 1023L <= 0L) {
                int bitsToShift = (int)(-1L * e - 1023L + 1L);
                f = bitsToShift <= 53 ? (f >>= bitsToShift) : 0L;
                e = -1023L;
            }
            f >>= 4;
            f &= 0xFFFFFFFFFFFFFL;
        }
        if ((e += 1023L) >= 2047L) {
            return s == 0L ? Double.MAX_VALUE : -1.7976931348623157E308;
        }
        ByteBuffer b = ByteBuffer.allocate(8).putLong(s | e << 52 | f);
        return b.getDouble(0);
    }

    static {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
        slf4jLogger.info("Using EasySMF data conversion");
    }
}

