/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import com.blackhillsoftware.smf.internal.Conversions;
import com.ibm.jzos.fields.AssemblerDatatypeFactory;
import com.ibm.jzos.fields.BinaryAsBigIntegerField;
import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.BinaryAsLongField;
import com.ibm.jzos.fields.IbmDoubleField;
import com.ibm.jzos.fields.IbmFloatField;
import com.ibm.jzos.fields.PackedDecimalAsBigIntegerField;
import com.ibm.jzos.fields.PackedDecimalAsIntField;
import com.ibm.jzos.fields.PackedDecimalAsLongField;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConversionsJzos
extends Conversions {
    private static AssemblerDatatypeFactory datatypes;
    private static IbmDoubleField LongFPHex;
    private static IbmFloatField ShortFPHex;
    private static BinaryAsIntField UnsignedBinary2;
    private static BinaryAsIntField UnsignedBinary3;
    private static BinaryAsLongField UnsignedBinary4;
    private static BinaryAsLongField UnsignedBinary5;
    private static BinaryAsLongField UnsignedBinary6;
    private static BinaryAsLongField UnsignedBinary7;
    private static BinaryAsLongField UnsignedBinary8;
    private static BinaryAsIntField SignedBinary2;
    private static BinaryAsIntField SignedBinary3;
    private static BinaryAsIntField SignedBinary4;
    private static BinaryAsLongField SignedBinary5;
    private static BinaryAsLongField SignedBinary6;
    private static BinaryAsLongField SignedBinary7;
    private static BinaryAsLongField SignedBinary8;
    private static BinaryAsBigIntegerField UnsignedBinary8BigInteger;
    private static BinaryAsBigIntegerField UnsignedBinary4BigInteger;
    private static BinaryAsBigIntegerField UnsignedBinary2BigInteger;
    private static PackedDecimalAsIntField Packed1;
    private static PackedDecimalAsIntField Packed2;
    private static PackedDecimalAsIntField Packed3;
    private static PackedDecimalAsIntField Packed4;
    private static PackedDecimalAsLongField[] packedLong;
    private static PackedDecimalAsBigIntegerField[] packedBigInteger;
    private static ArrayList<BinaryAsBigIntegerField> binaryAsBigIntegerFields;
    private static Map<Integer, BinaryAsBigIntegerField> bigBinaryAsBigIntegerFields;
    private static ArrayList<BinaryAsBigIntegerField> binaryAsSignedBigIntegerFields;
    private static Map<Integer, BinaryAsBigIntegerField> bigBinaryAsSignedBigIntegerFields;

    ConversionsJzos() {
    }

    @Override
    float ConvertFloat(byte[] data, int offset) {
        return ShortFPHex.getFloat(data, offset);
    }

    @Override
    double ConvertDouble(byte[] data, int offset) {
        return LongFPHex.getDouble(data, offset);
    }

    @Override
    int ConvertUnsignedBinary2(byte[] data, int offset) {
        return UnsignedBinary2.getInt(data, offset);
    }

    @Override
    int ConvertUnsignedBinary3(byte[] data, int offset) {
        return UnsignedBinary3.getInt(data, offset);
    }

    @Override
    long ConvertUnsignedBinary4(byte[] data, int offset) {
        return UnsignedBinary4.getLong(data, offset);
    }

    @Override
    long ConvertUnsignedBinary5(byte[] data, int offset) {
        return UnsignedBinary5.getLong(data, offset);
    }

    @Override
    long ConvertUnsignedBinary6(byte[] data, int offset) {
        return UnsignedBinary6.getLong(data, offset);
    }

    @Override
    long ConvertUnsignedBinary7(byte[] data, int offset) {
        return UnsignedBinary7.getLong(data, offset);
    }

    @Override
    long ConvertUnsignedBinary8(byte[] data, int offset) {
        return UnsignedBinary8.getLong(data, offset);
    }

    @Override
    int ConvertSignedBinary2(byte[] data, int offset) {
        return SignedBinary2.getInt(data, offset);
    }

    @Override
    int ConvertSignedBinary3(byte[] data, int offset) {
        return SignedBinary3.getInt(data, offset);
    }

    @Override
    int ConvertSignedBinary4(byte[] data, int offset) {
        return SignedBinary4.getInt(data, offset);
    }

    @Override
    long ConvertSignedBinary5(byte[] data, int offset) {
        return SignedBinary5.getLong(data, offset);
    }

    @Override
    long ConvertSignedBinary6(byte[] data, int offset) {
        return SignedBinary6.getLong(data, offset);
    }

    @Override
    long ConvertSignedBinary7(byte[] data, int offset) {
        return SignedBinary7.getLong(data, offset);
    }

    @Override
    long ConvertSignedBinary8(byte[] data, int offset) {
        return SignedBinary8.getLong(data, offset);
    }

    @Override
    int ConvertPacked1(byte[] data, int offset) {
        return Packed1.getInt(data, offset);
    }

    @Override
    int ConvertPacked2(byte[] data, int offset) {
        return Packed2.getInt(data, offset);
    }

    @Override
    int ConvertPacked3(byte[] data, int offset) {
        return Packed3.getInt(data, offset);
    }

    @Override
    int ConvertPacked4(byte[] data, int offset) {
        return Packed4.getInt(data, offset);
    }

    @Override
    long ConvertPackedLong(byte[] data, int offset, int length) {
        if (length > 9) {
            throw new ArithmeticException("Packed field too large: " + Integer.toString(length));
        }
        return packedLong[length].getLong(data, offset);
    }

    @Override
    BigInteger ConvertPackedBigInteger(byte[] data, int offset, int length) {
        if (length > 16) {
            throw new ArithmeticException("Packed field too large: " + Integer.toString(length));
        }
        return packedBigInteger[length].getBigInteger(data, offset);
    }

    @Override
    BigInteger ConvertUnsignedBinary8BigInteger(byte[] data, int offset) {
        return UnsignedBinary8BigInteger.getBigInteger(data, offset);
    }

    @Override
    BigInteger ConvertUnsignedBinary4BigInteger(byte[] data, int offset) {
        return UnsignedBinary4BigInteger.getBigInteger(data, offset);
    }

    @Override
    BigInteger ConvertUnsignedBinary2BigInteger(byte[] data, int offset) {
        return UnsignedBinary2BigInteger.getBigInteger(data, offset);
    }

    @Override
    BigInteger ConvertBigInteger(byte[] data, int offset, int length) {
        if (length < 512) {
            BinaryAsBigIntegerField field;
            if (binaryAsBigIntegerFields.size() > length && (field = binaryAsBigIntegerFields.get(length)) != null) {
                return field.getBigInteger(data, offset);
            }
            binaryAsBigIntegerFields.ensureCapacity(length + 1);
            for (int i = binaryAsBigIntegerFields.size(); i <= length; ++i) {
                binaryAsBigIntegerFields.add(null);
            }
            field = this.createBigIntegerField(length);
            binaryAsBigIntegerFields.set(length, field);
            return field.getBigInteger(data, offset);
        }
        BinaryAsBigIntegerField field = bigBinaryAsBigIntegerFields.get(length);
        if (field == null) {
            field = this.createBigIntegerField(length);
            bigBinaryAsBigIntegerFields.put(length, field);
        }
        return field.getBigInteger(data, offset);
    }

    private BinaryAsBigIntegerField createBigIntegerField(int length) {
        datatypes.setOffset(0);
        return datatypes.getBinaryAsBigIntegerField(length, false);
    }

    @Override
    BigInteger ConvertSignedBigInteger(byte[] data, int offset, int length) {
        if (length < 512) {
            BinaryAsBigIntegerField field;
            if (binaryAsSignedBigIntegerFields.size() > length && (field = binaryAsSignedBigIntegerFields.get(length)) != null) {
                return field.getBigInteger(data, offset);
            }
            binaryAsSignedBigIntegerFields.ensureCapacity(length + 1);
            for (int i = binaryAsSignedBigIntegerFields.size(); i <= length; ++i) {
                binaryAsSignedBigIntegerFields.add(null);
            }
            field = this.createSignedBigIntegerField(length);
            binaryAsSignedBigIntegerFields.set(length, field);
            return field.getBigInteger(data, offset);
        }
        BinaryAsBigIntegerField field = bigBinaryAsSignedBigIntegerFields.get(length);
        if (field == null) {
            field = this.createSignedBigIntegerField(length);
            bigBinaryAsSignedBigIntegerFields.put(length, field);
        }
        return field.getBigInteger(data, offset);
    }

    private BinaryAsBigIntegerField createSignedBigIntegerField(int length) {
        datatypes.setOffset(0);
        return datatypes.getBinaryAsBigIntegerField(length, true);
    }

    static {
        int i;
        packedLong = new PackedDecimalAsLongField[10];
        packedBigInteger = new PackedDecimalAsBigIntegerField[17];
        Logger slf4jLogger = LoggerFactory.getLogger((String)"EasySMF:JE");
        slf4jLogger.info("Using JZOS data conversion");
        datatypes = new AssemblerDatatypeFactory();
        datatypes.setOffset(0);
        LongFPHex = datatypes.getIbmDoubleField();
        datatypes.setOffset(0);
        ShortFPHex = datatypes.getIbmFloatField();
        datatypes.setOffset(0);
        UnsignedBinary2 = datatypes.getBinaryAsIntField(2, false);
        datatypes.setOffset(0);
        UnsignedBinary3 = datatypes.getBinaryAsIntField(3, false);
        datatypes.setOffset(0);
        UnsignedBinary4 = datatypes.getBinaryAsLongField(4, false);
        datatypes.setOffset(0);
        UnsignedBinary5 = datatypes.getBinaryAsLongField(5, false);
        datatypes.setOffset(0);
        UnsignedBinary6 = datatypes.getBinaryAsLongField(6, false);
        datatypes.setOffset(0);
        UnsignedBinary7 = datatypes.getBinaryAsLongField(7, false);
        datatypes.setOffset(0);
        UnsignedBinary8 = datatypes.getBinaryAsLongField(8, false);
        datatypes.setOffset(0);
        SignedBinary2 = datatypes.getBinaryAsIntField(2, true);
        datatypes.setOffset(0);
        SignedBinary3 = datatypes.getBinaryAsIntField(3, true);
        datatypes.setOffset(0);
        SignedBinary4 = datatypes.getBinaryAsIntField(4, true);
        datatypes.setOffset(0);
        SignedBinary5 = datatypes.getBinaryAsLongField(5, true);
        datatypes.setOffset(0);
        SignedBinary6 = datatypes.getBinaryAsLongField(6, true);
        datatypes.setOffset(0);
        SignedBinary7 = datatypes.getBinaryAsLongField(7, true);
        datatypes.setOffset(0);
        SignedBinary8 = datatypes.getBinaryAsLongField(8, true);
        datatypes.setOffset(0);
        UnsignedBinary8BigInteger = datatypes.getBinaryAsBigIntegerField(8, false);
        datatypes.setOffset(0);
        UnsignedBinary4BigInteger = datatypes.getBinaryAsBigIntegerField(4, false);
        datatypes.setOffset(0);
        UnsignedBinary2BigInteger = datatypes.getBinaryAsBigIntegerField(2, false);
        datatypes.setOffset(0);
        Packed1 = datatypes.getPackedDecimalAsIntField(1, true);
        datatypes.setOffset(0);
        Packed2 = datatypes.getPackedDecimalAsIntField(2, true);
        datatypes.setOffset(0);
        Packed3 = datatypes.getPackedDecimalAsIntField(3, true);
        datatypes.setOffset(0);
        Packed4 = datatypes.getPackedDecimalAsIntField(4, true);
        for (i = 1; i < packedLong.length; ++i) {
            datatypes.setOffset(0);
            ConversionsJzos.packedLong[i] = datatypes.getPackedDecimalAsLongField(i, true);
        }
        for (i = 1; i < packedBigInteger.length; ++i) {
            datatypes.setOffset(0);
            ConversionsJzos.packedBigInteger[i] = datatypes.getPackedDecimalAsBigIntegerField(i, 0, true);
        }
        binaryAsBigIntegerFields = new ArrayList();
        bigBinaryAsBigIntegerFields = new HashMap<Integer, BinaryAsBigIntegerField>();
        binaryAsSignedBigIntegerFields = new ArrayList();
        bigBinaryAsSignedBigIntegerFields = new HashMap<Integer, BinaryAsBigIntegerField>();
    }
}

