/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectCache<TKey, TValue> {
    private ConcurrentHashMap<TKey, WeakReference<TValue>> cache = new ConcurrentHashMap();
    private static final int PRUNEINTERVAL = 500;
    private int nextPrune = 500;

    public TValue tryGet(TKey key) {
        WeakReference<TValue> wr = this.cache.get(key);
        return wr == null ? null : (TValue)wr.get();
    }

    public synchronized void put(TKey key, TValue value) {
        this.cache.put(key, new WeakReference<TValue>(value));
        if (this.cache.size() >= this.nextPrune) {
            ArrayList<TKey> removeKeys = new ArrayList<TKey>();
            for (Map.Entry<TKey, WeakReference<TValue>> entry : this.cache.entrySet()) {
                if (entry.getValue().get() != null) continue;
                removeKeys.add(entry.getKey());
            }
            for (Map.Entry<Object, WeakReference<Object>> removeKey : removeKeys) {
                this.cache.remove(removeKey);
            }
            this.nextPrune = this.cache.size() + 500;
        }
    }
}

