/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.readerbuilder;

import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.readerbuilder.LogstreamBuilder;
import com.blackhillsoftware.smf.readerbuilder.LogstreamBuilderCommon;
import com.ibm.jzos.ZUtil;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;

public class LogstreamBuilderLocal<T extends LogstreamBuilderLocal<T>>
extends LogstreamBuilderCommon<LogstreamBuilderLocal<T>, LogstreamBuilderLocal<T>> {
    @Override
    protected LogstreamBuilderLocal<T> self() {
        return this;
    }

    <T1 extends LogstreamBuilder<T1>> LogstreamBuilderLocal(LogstreamBuilder<T1> other) {
        super(other);
    }

    public LogstreamBuilderLocal<T> from(LocalTime localTime) {
        this.checkLocalDate();
        return this.from(this.parms.currentLocalDate.atTime(localTime));
    }

    public LogstreamBuilderLocal<T> from(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime);
        if (this.parms.toLocalDateTime != null && localDateTime.isAfter(this.parms.toLocalDateTime)) {
            throw new IllegalArgumentException("FROM time is after TO time");
        }
        this.parms.fromLocalDateTime = localDateTime;
        return this.self();
    }

    public LogstreamBuilderLocal<T> to(LocalTime localTime) {
        this.checkLocalDate();
        return this.to(this.parms.currentLocalDate.atTime(localTime));
    }

    public LogstreamBuilderLocal<T> to(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime);
        if (this.parms.fromLocalDateTime != null && localDateTime.isBefore(this.parms.fromLocalDateTime)) {
            throw new IllegalArgumentException("TO time is before FROM time");
        }
        this.parms.toLocalDateTime = localDateTime;
        return this.self();
    }

    private void checkLocalDate() {
        if (this.parms.currentLocalDate == null) {
            this.parms.currentLocalDate = ZonedDateTime.now().withZoneSameInstant(LogstreamBuilderLocal.cvtldto()).toLocalDate();
        }
    }

    private static ZoneOffset cvtldto() {
        long cvtptr = ZUtil.peekOSMemory((long)16L, (int)4);
        long cvtext2 = ZUtil.peekOSMemory((long)(cvtptr + 328L), (int)4);
        byte[] tz = new byte[8];
        ZUtil.peekOSMemory((long)(cvtext2 + 56L), (byte[])tz);
        return Util.Binary8_STCK_GMT_Offset(tz, 0);
    }
}

