/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.readerbuilder;

import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.SmfRecordReaderBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class ReaderBuilderBase<T extends ReaderBuilderBase<T>>
extends SmfRecordReaderBuilder {
    private List<TypeSubtype> includes = new ArrayList<TypeSubtype>();

    <T1 extends ReaderBuilderBase<T1>> ReaderBuilderBase(ReaderBuilderBase<T1> other) {
        this.includes.addAll(other.includes);
    }

    ReaderBuilderBase() {
    }

    protected abstract T self();

    public T include(int smfType) {
        this.includes.add(new TypeSubtype(smfType, null));
        return this.self();
    }

    public T include(int smfType, int subtype) {
        this.includes.add(new TypeSubtype(smfType, subtype));
        return this.self();
    }

    protected abstract SmfRecordReader createReader() throws IOException;

    @Override
    public SmfRecordReader build() throws IOException {
        SmfRecordReader reader = this.createReader();
        this.setIncludes(reader);
        return reader;
    }

    private void setIncludes(SmfRecordReader reader) {
        for (TypeSubtype entry : this.includes) {
            if (entry.subtype == null) {
                reader.include(entry.smfType);
                continue;
            }
            reader.include(entry.smfType, entry.subtype);
        }
    }

    private static class TypeSubtype {
        Integer smfType;
        Integer subtype;

        TypeSubtype(Integer smfType, Integer subtype) {
            this.smfType = smfType;
            this.subtype = subtype;
        }
    }
}

