/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.security;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.security.PoeClass;
import com.blackhillsoftware.smf.security.SessionType;

public final class Token
extends SmfData {
    public static final int TOKVER01 = 1;
    public static final int TOKCVER = 1;
    public static final int TOKENCR = 128;
    public static final int TOKLT19 = 32;
    public static final int TOKVXPRP = 16;
    public static final int TOKUNUSR = 8;
    public static final int TOKLOGU = 4;
    public static final int TOKRSPEC = 2;
    public static final int TOKDFLT = 128;
    public static final int TOKUDUS = 64;
    public static final int TOKERR = 16;
    public static final int TOKTRST = 8;
    public static final int TOKSUS = 4;
    public static final int TOKREMOT = 2;
    public static final int TOKPRIV = 1;
    public static final int TOKDGRP = 128;
    public static final int TOKDSEC = 64;
    public static final int TOKNETF = 32;
    public static final int TOKIPV = 16;
    public static final int TOKWDWN = 8;
    public static final int TOKCURLN = 80;

    private Token(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Token(byte[] Data2) {
        super(Data2);
    }

    public int toklen() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int tokvers() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public int tokflg1() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean tokencr() {
        return Util.ConvertFlag(this.data, this.tokflg1(), 128);
    }

    public boolean toklt19() {
        return Util.ConvertFlag(this.data, this.tokflg1(), 32);
    }

    public boolean tokvxprp() {
        return Util.ConvertFlag(this.data, this.tokflg1(), 16);
    }

    public boolean tokunusr() {
        return Util.ConvertFlag(this.data, this.tokflg1(), 8);
    }

    public boolean toklogu() {
        return Util.ConvertFlag(this.data, this.tokflg1(), 4);
    }

    public boolean tokrspec() {
        return Util.ConvertFlag(this.data, this.tokflg1(), 2);
    }

    public SessionType tokstyp() {
        int value = Util.ConvertUnsignedBinary1(this.data, 3);
        return SessionType.from(value);
    }

    public int tokstypRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public int tokflg2() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean tokdflt() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 128);
    }

    public boolean tokudus() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 64);
    }

    public boolean tokerr() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 16);
    }

    public boolean toktrst() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 8);
    }

    public boolean toksus() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 4);
    }

    public boolean tokremot() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 2);
    }

    public boolean tokpriv() {
        return Util.ConvertFlag(this.data, this.tokflg2(), 1);
    }

    public PoeClass tokpoex() {
        int value = Util.ConvertUnsignedBinary1(this.data, 5);
        return PoeClass.from(value);
    }

    public int tokpoexRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public int tokflg3() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public boolean tokdgrp() {
        return Util.ConvertFlag(this.data, this.tokflg3(), 128);
    }

    public boolean tokdsec() {
        return Util.ConvertFlag(this.data, this.tokflg3(), 64);
    }

    public boolean toknetf() {
        return Util.ConvertFlag(this.data, this.tokflg3(), 32);
    }

    public boolean tokipv() {
        return Util.ConvertFlag(this.data, this.tokflg3(), 16);
    }

    public boolean tokwdwn() {
        return Util.ConvertFlag(this.data, this.tokflg3(), 8);
    }

    public String tokscl() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String tokxnod() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String toksusr() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String toksnod() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String toksgrp() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String tokiplok() {
        return Util.ConvertEbcdic(this.data, 48, 16);
    }

    public String tokpoe() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String toknetw() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public String tokuser() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public String tokgrup() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public static Token create(byte[] Data2, int offset, int length) {
        return new Token(Data2, offset, length);
    }

    static enum Field {
        toklen(0, 1),
        tokvers(1, 1),
        tokflg1(2, 1),
        tokstyp(3, 1),
        tokflg2(4, 1),
        tokpoex(5, 1),
        tokflg3(6, 1),
        tokscl(8, 8),
        tokxnod(16, 8),
        toksusr(24, 8),
        toksnod(32, 8),
        toksgrp(40, 8),
        tokiplok(48, 16),
        tokpoe(48, 8),
        toknetw(56, 8),
        tokuser(64, 8),
        tokgrup(72, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

