/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.CertDigestAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.CertEncryptionMethod;
import com.blackhillsoftware.smf.smf119.zert.EncryptionAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.KeyType;
import com.blackhillsoftware.smf.smf119.zert.MessageAuthAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.SSHAuthMethod;
import com.blackhillsoftware.smf.smf119.zert.SSHKexMethod;
import com.blackhillsoftware.smf.smf119.zert.SSHProtocolVersion;
import com.blackhillsoftware.smf.smf119.zert.SignatureMethod;
import com.blackhillsoftware.smf.smf119.zert.Source;

public final class ZertSummarySSHSection
extends SmfData {
    public static final int SMF119SS_SSH_Enc_Then_Mac_In = 128;
    public static final int SMF119SS_SSH_Enc_Then_Mac_Out = 64;

    private ZertSummarySSHSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Source smf119ssSshSource() {
        int value = Util.ConvertUnsignedBinary1(this.data, 0);
        return Source.from(value);
    }

    public int smf119ssSshSourceRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public SSHProtocolVersion smf119ssSshProtVer() {
        int value = Util.ConvertUnsignedBinary1(this.data, 2);
        return SSHProtocolVersion.from(value);
    }

    public int smf119ssSshProtVerRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public int smf119ssSshCryptoFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf119ssSshEncThenMacIn() {
        return Util.ConvertFlag(this.data, this.smf119ssSshCryptoFlags(), 128);
    }

    public boolean smf119ssSshEncThenMacOut() {
        return Util.ConvertFlag(this.data, this.smf119ssSshCryptoFlags(), 64);
    }

    public SSHAuthMethod smf119ssSshAuthMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 4);
        return SSHAuthMethod.from(value);
    }

    public int smf119ssSshAuthMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public SSHAuthMethod smf119ssSshAuthMethod2() {
        int value = Util.ConvertUnsignedBinary2(this.data, 6);
        return SSHAuthMethod.from(value);
    }

    public int smf119ssSshAuthMethod2RawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 6);
    }

    public EncryptionAlgorithm smf119ssSshInEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 8);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119ssSshInEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public MessageAuthAlgorithm smf119ssSshInMsgAuth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 10);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119ssSshInMsgAuthRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public SSHKexMethod smf119ssSshKexMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 12);
        return SSHKexMethod.from(value);
    }

    public int smf119ssSshKexMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public EncryptionAlgorithm smf119ssSshOutEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 14);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119ssSshOutEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public MessageAuthAlgorithm smf119ssSshOutMsgAuth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 16);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119ssSshOutMsgAuthRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public KeyType smf119ssSshSKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 18);
        return KeyType.from(value);
    }

    public int smf119ssSshSKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 18);
    }

    public int smf119ssSshSKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public KeyType smf119ssSshCKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 22);
        return KeyType.from(value);
    }

    public int smf119ssSshCKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf119ssSshCKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public SignatureMethod smf119ssSshSCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 26);
        return SignatureMethod.from(value);
    }

    public int smf119ssSshSCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public CertEncryptionMethod smf119ssSshSCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 28);
        return CertEncryptionMethod.from(value);
    }

    public int smf119ssSshSCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public CertDigestAlgorithm smf119ssSshSCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 30);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119ssSshSCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public KeyType smf119ssSshSCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 32);
        return KeyType.from(value);
    }

    public int smf119ssSshSCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf119ssSshSCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public SignatureMethod smf119ssSshCCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 36);
        return SignatureMethod.from(value);
    }

    public int smf119ssSshCCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public CertEncryptionMethod smf119ssSshCCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 38);
        return CertEncryptionMethod.from(value);
    }

    public int smf119ssSshCCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public CertDigestAlgorithm smf119ssSshCCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 40);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119ssSshCCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public KeyType smf119ssSshCCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 42);
        return KeyType.from(value);
    }

    public int smf119ssSshCCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf119ssSshCCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public static ZertSummarySSHSection create(byte[] Data2, int offset, int length) {
        return new ZertSummarySSHSection(Data2, offset, length);
    }

    static enum Field {
        smf119ssSshSource(0, 1),
        smf119ssSshProtVer(2, 1),
        smf119ssSshCryptoFlags(3, 1),
        smf119ssSshAuthMethod(4, 2),
        smf119ssSshAuthMethod2(6, 2),
        smf119ssSshInEncAlg(8, 2),
        smf119ssSshInMsgAuth(10, 2),
        smf119ssSshKexMethod(12, 2),
        smf119ssSshOutEncAlg(14, 2),
        smf119ssSshOutMsgAuth(16, 2),
        smf119ssSshSKeyType(18, 2),
        smf119ssSshSKeyLen(20, 2),
        smf119ssSshCKeyType(22, 2),
        smf119ssSshCKeyLen(24, 2),
        smf119ssSshSCertSignatureMethod(26, 2),
        smf119ssSshSCertEncMethod(28, 2),
        smf119ssSshSCertDigestAlg(30, 2),
        smf119ssSshSCertKeyType(32, 2),
        smf119ssSshSCertKeyLen(34, 2),
        smf119ssSshCCertSignatureMethod(36, 2),
        smf119ssSshCCertEncMethod(38, 2),
        smf119ssSshCCertDigestAlg(40, 2),
        smf119ssSshCCertKeyType(42, 2),
        smf119ssSshCCertKeyLen(44, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

